/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.reporters.linux.Linux;
import com.github.writethemfirst.approvals.reporters.linux.MacOs;
import com.github.writethemfirst.approvals.reporters.windows.Windows;
import java.util.Arrays;
import java.util.Optional;

public enum SupportedOs {
    WINDOWS("windows", Windows.DEFAULT),
    MACOS("mac", MacOs.DEFAULT),
    LINUX("linux", Linux.DEFAULT);

    private final Reporter defaultReporter;
    public final boolean active;

    private SupportedOs(String prefix, Reporter defaultReporter) {
        this.defaultReporter = defaultReporter;
        String osName = System.getProperty("os.name").toLowerCase();
        this.active = osName.startsWith(prefix);
    }

    public static Optional<Reporter> osDefaultReporter() {
        return Arrays.stream(SupportedOs.values()).filter(os -> os.active).map(os -> os.defaultReporter).findFirst();
    }
}

