/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.files;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import com.github.writethemfirst.approvals.reporters.ThrowsReporter;
import com.github.writethemfirst.approvals.utils.FileUtils;
import java.util.List;

public class MatchesAndMismatches {
    private final List<ApprovalFiles> matches;
    private final List<ApprovalFiles> mismatches;

    MatchesAndMismatches(List<ApprovalFiles> matches, List<ApprovalFiles> mismatches) {
        this.matches = matches;
        this.mismatches = mismatches;
    }

    public void reportMismatches(Reporter reporter) {
        if (this.mismatches.size() > 0) {
            ApprovalFiles firstMismatch = this.mismatches.get(0);
            if (this.mismatches.size() > 1) {
                reporter.mismatch(firstMismatch.parent());
            } else {
                reporter.mismatch(firstMismatch);
            }
        }
    }

    public void throwMismatches() {
        this.mismatches.forEach(mismatch -> new ThrowsReporter().mismatch((ApprovalFiles)mismatch));
    }

    public void cleanupReceivedFiles() {
        this.matches.forEach(ar -> FileUtils.silentRemove(ar.received));
        if (this.mismatches.isEmpty() && !this.matches.isEmpty()) {
            ApprovalFiles firstMatch = this.matches.get(0);
            FileUtils.silentRecursiveRemove(firstMatch.parent().received);
        }
    }
}

