/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.files.ApprovalFiles;
import java.util.Optional;
import java.util.stream.Stream;

public class FirstWorkingReporter
implements Reporter {
    private final Reporter[] reporters;
    private Optional<Reporter> firstWorking;

    public FirstWorkingReporter(Reporter ... reporters) {
        this.reporters = reporters;
    }

    @Override
    public void mismatch(ApprovalFiles files) {
        if (this.firstWorking().isPresent()) {
            this.firstWorking().get().mismatch(files);
        } else {
            System.err.println(String.format("No working reporter for reporting mismatch between %s and %s", files.approved, files.received));
        }
    }

    @Override
    public boolean isAvailable() {
        return this.firstWorking().isPresent();
    }

    private Optional<Reporter> firstWorking() {
        boolean firstTime;
        boolean bl = firstTime = this.firstWorking == null;
        if (firstTime) {
            this.firstWorking = this.findFirstAvailable();
        }
        return this.firstWorking;
    }

    private Optional<Reporter> findFirstAvailable() {
        return Stream.of(this.reporters).filter(Reporter::isAvailable).findFirst();
    }
}

