/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.reporters;

import com.github.writethemfirst.approvals.Reporter;
import com.github.writethemfirst.approvals.reporters.CommandReporter;
import com.github.writethemfirst.approvals.reporters.CommandReporterSpec;
import com.github.writethemfirst.approvals.reporters.FirstWorkingReporter;
import com.github.writethemfirst.approvals.reporters.ReporterConfiguration;
import com.github.writethemfirst.approvals.reporters.linux.Linux;
import com.github.writethemfirst.approvals.reporters.macos.MacOs;
import com.github.writethemfirst.approvals.reporters.windows.Windows;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public enum SupportedOs {
    WINDOWS("windows", Windows.knownCommandReporters),
    MAC_OS("mac", MacOs.knownCommandReporters),
    LINUX("linux", Linux.knownCommandReporters);

    public final List<CommandReporterSpec> specs;
    public final boolean active;

    private SupportedOs(String prefix, List<CommandReporterSpec> specs) {
        this.specs = specs;
        String osName = System.getProperty("os.name").toLowerCase();
        this.active = osName.startsWith(prefix);
    }

    public static Optional<Reporter> osDefaultReporter() {
        return SupportedOs.activeOs().map(SupportedOs::defaultReporter);
    }

    Reporter defaultReporter() {
        Optional<CommandReporter> configuredReporter = ReporterConfiguration.read();
        if (configuredReporter.isPresent()) {
            System.out.println(String.format("Using reporter configured in %s", ReporterConfiguration.dotFile));
            return configuredReporter.get();
        }
        System.err.println(String.format("No available reporter configured in %s", ReporterConfiguration.dotFile));
        return new FirstWorkingReporter((Reporter[])this.specs.stream().map(CommandReporterSpec::reporter).toArray(Reporter[]::new));
    }

    public static Optional<SupportedOs> activeOs() {
        return Arrays.stream(SupportedOs.values()).filter(os -> os.active).findFirst();
    }
}

