/*
 * Decompiled with CFR 0.152.
 */
package com.github.writethemfirst.approvals.utils;

import com.github.writethemfirst.approvals.utils.ExecutableCommand;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class CommandFinder {
    private static final int MAX_FOLDERS_DEPTH = 5;
    static String WINDOWS_ENV_PROGRAM_FILES = "ProgramFiles";
    static String WINDOWS_ENV_PROGRAM_FILES_X86 = "ProgramFiles(x86)";
    static final String PROGRAM_FILES_KEY = "%programFiles%";
    private final Runtime runtime;
    private final String path;
    private final String executable;
    private ExecutableCommand cachedExecutableCommand;
    private boolean searched = false;
    private final String programFilesFolder;
    private final String programFilesX86Folder;

    public CommandFinder(String path, String executable) {
        this(path, executable, Runtime.getRuntime(), System.getenv());
    }

    CommandFinder(String path, String executable, Runtime runtime, Map<String, String> env) {
        this.path = path;
        this.executable = executable;
        this.runtime = runtime;
        this.programFilesFolder = env.get(WINDOWS_ENV_PROGRAM_FILES);
        this.programFilesX86Folder = env.get(WINDOWS_ENV_PROGRAM_FILES_X86);
    }

    public Optional<ExecutableCommand> executableCommand() {
        this.searchForLatest();
        return Optional.ofNullable(this.cachedExecutableCommand);
    }

    private void searchForLatest() {
        if (!this.searched) {
            this.searchForExe().ifPresent(s -> {
                this.cachedExecutableCommand = new ExecutableCommand((String)s, this.runtime);
            });
            this.searched = true;
        }
    }

    public Optional<String> searchForExe() {
        return this.searchForAllExe().max(Comparator.naturalOrder());
    }

    public Stream<String> searchForAllExe() {
        Stream<Path> programFilesFolders = Stream.concat(this.replaced(this.programFilesFolder), this.replaced(this.programFilesX86Folder));
        Stream<Path> possiblePaths = Stream.concat(programFilesFolders, this.notReplaced());
        try {
            return possiblePaths.flatMap(this::matchingCommandInPath).map(Path::toString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }

    private Stream<Path> matchingCommandInPath(Path possiblePath) {
        try {
            return Files.find(possiblePath, 5, (p, a) -> p.endsWith(this.executable), FileVisitOption.FOLLOW_LINKS);
        }
        catch (IOException e) {
            e.printStackTrace();
            return Stream.empty();
        }
    }

    private Stream<Path> replaced(String folder) {
        if (folder == null) {
            return Stream.empty();
        }
        Path path = Paths.get(this.path.replace(PROGRAM_FILES_KEY, folder), new String[0]);
        return path.toFile().isDirectory() ? Stream.of(path) : Stream.empty();
    }

    private Stream<Path> notReplaced() {
        if (this.path.contains(PROGRAM_FILES_KEY)) {
            return Stream.empty();
        }
        Path pat = Paths.get(this.path, new String[0]);
        return pat.toFile().isDirectory() ? Stream.of(pat) : Stream.empty();
    }
}

