/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.core.base;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.log.Log;
import com.github.xuejike.query.core.criteria.SelectCriteria;
import com.github.xuejike.query.core.criteria.WhereCriteria;
import com.github.xuejike.query.core.enums.OrderType;
import com.github.xuejike.query.core.enums.StringMatchMode;
import com.github.xuejike.query.core.enums.WhereOperation;
import com.github.xuejike.query.core.exception.LambdaQueryException;
import com.github.xuejike.query.core.po.BetweenObj;
import com.github.xuejike.query.core.po.FieldInfo;
import com.github.xuejike.query.core.po.LikeValObj;
import com.github.xuejike.query.core.po.QueryInfo;
import com.github.xuejike.query.core.po.QueryItem;
import com.github.xuejike.query.core.tool.lambda.CascadeField;
import com.github.xuejike.query.core.tool.lambda.FieldFunction;
import com.github.xuejike.query.core.tool.lambda.LambdaTool;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class BaseWhereQuery<T, F, C extends BaseWhereQuery<T, F, C>>
implements WhereCriteria<C, F>,
SelectCriteria<C, F> {
    protected Map<Object, Map<WhereOperation, Object>> whereMap = new ConcurrentHashMap<Object, Map<WhereOperation, Object>>();
    protected List<BaseWhereQuery<T, F, ?>> orList = new LinkedList();
    protected List<FieldInfo> selectList = new LinkedList<FieldInfo>();
    protected List<FieldInfo> excludeList = new LinkedList<FieldInfo>();
    protected Map<FieldInfo, OrderType> orderMap = new ConcurrentHashMap<FieldInfo, OrderType>();
    protected C returnObj = this;

    public BaseWhereQuery() {
    }

    public BaseWhereQuery(C returnObj) {
        this.returnObj = returnObj;
    }

    @Override
    public C ne(F field, Object val) {
        this.putWhere(WhereOperation.ne, field, val);
        return this.returnObj;
    }

    @Override
    public C ne(boolean condition, F field, Object val) {
        this.doIt(condition, () -> this.ne((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C eq(F field, Object val) {
        this.putWhere(WhereOperation.eq, field, val);
        return this.returnObj;
    }

    @Override
    public C eq(boolean condition, F field, Object val) {
        this.doIt(condition, () -> this.eq((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C gt(F field, Object val) {
        this.putWhere(WhereOperation.gt, field, val);
        return this.returnObj;
    }

    @Override
    public C gt(boolean condition, F field, Object val) {
        this.doIt(condition, () -> this.gt((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C gte(F field, Object val) {
        this.putWhere(WhereOperation.gte, field, val);
        return this.returnObj;
    }

    @Override
    public C gte(boolean condition, F field, Object val) {
        this.doIt(condition, () -> this.gte((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C lt(F field, Object val) {
        this.putWhere(WhereOperation.lt, field, val);
        return this.returnObj;
    }

    @Override
    public C lt(boolean condition, F field, Object val) {
        this.doIt(condition, () -> this.lt((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C lte(F field, Object val) {
        this.putWhere(WhereOperation.lte, field, val);
        return this.returnObj;
    }

    @Override
    public C lte(boolean condition, F field, Object val) {
        this.doIt(condition, () -> this.lte((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C like(F field, String val) {
        this.putWhere(WhereOperation.like, field, val);
        return this.returnObj;
    }

    @Override
    public C like(boolean condition, F field, String val) {
        this.doIt(condition, () -> this.like((Object)field, val, StringMatchMode.EXACT));
        return this.returnObj;
    }

    @Override
    public C like(F field, String val, StringMatchMode stringMatchMode) {
        this.putWhere(WhereOperation.like, field, new LikeValObj(val, stringMatchMode));
        return this.returnObj;
    }

    @Override
    public C like(boolean condition, F field, String val, StringMatchMode stringMatchMode) {
        this.doIt(condition, () -> this.like((Object)field, val, stringMatchMode));
        return this.returnObj;
    }

    @Override
    public C in(F field, Object ... val) {
        this.putWhere(WhereOperation.in, field, CollUtil.newArrayList((Object[])val));
        return this.returnObj;
    }

    @Override
    public C in(boolean condition, F field, Object ... val) {
        this.doIt(condition, () -> this.in((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C notIn(F field, Object ... val) {
        this.putWhere(WhereOperation.notIn, field, CollUtil.newArrayList((Object[])val));
        return this.returnObj;
    }

    @Override
    public C notIn(boolean condition, F field, Object ... val) {
        this.doIt(condition, () -> this.notIn((Object)field, val));
        return this.returnObj;
    }

    @Override
    public C in(F field, Collection<Object> val) {
        this.putWhere(WhereOperation.in, field, val);
        return this.returnObj;
    }

    @Override
    public C in(boolean condition, F field, Collection<Object> val) {
        this.doIt(condition, () -> this.in((Object)field, (Collection)val));
        return this.returnObj;
    }

    @Override
    public C notIn(F field, Collection<Object> val) {
        this.putWhere(WhereOperation.notIn, field, val);
        return this.returnObj;
    }

    @Override
    public C notIn(boolean condition, F field, Collection<Object> val) {
        this.doIt(condition, () -> this.notIn((Object)field, (Collection)val));
        return this.returnObj;
    }

    @Override
    public C isNull(F field) {
        this.putWhere(WhereOperation.isNull, field, null);
        return this.returnObj;
    }

    @Override
    public C isNull(boolean condition, F field) {
        this.doIt(condition, () -> this.isNull((Object)field));
        return this.returnObj;
    }

    @Override
    public C notNull(F field) {
        this.putWhere(WhereOperation.notNull, field, null);
        return this.returnObj;
    }

    @Override
    public C notNull(boolean condition, F field) {
        this.doIt(condition, () -> this.notNull((Object)field));
        return this.returnObj;
    }

    @Override
    public C between(F field, Object start, Object end) {
        this.putWhere(WhereOperation.between, field, new BetweenObj(start, end));
        return this.returnObj;
    }

    @Override
    public C between(boolean condition, F field, Object start, Object end) {
        this.doIt(condition, () -> this.between((Object)field, start, end));
        return this.returnObj;
    }

    public boolean isEmpty() {
        return CollUtil.isEmpty(this.whereMap) && CollUtil.isEmpty(this.orList) && CollUtil.isEmpty(this.selectList) && CollUtil.isEmpty(this.excludeList) && CollUtil.isEmpty(this.orderMap);
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    protected void doIt(boolean condition, Runnable run) {
        if (condition) {
            run.run();
        }
    }

    protected void putWhere(WhereOperation whereOperation, F field, Object val) {
        Map<WhereOperation, Object> fieldMap = null;
        if (field instanceof FieldFunction && !(field instanceof CascadeField)) {
            FieldInfo fieldInfo = LambdaTool.getFieldInfo((FieldFunction)field);
            fieldMap = this.getFieldMap(fieldInfo);
        } else {
            fieldMap = this.getFieldMap(field);
        }
        if (fieldMap.containsKey((Object)whereOperation)) {
            Log.get().warn("\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\u76f8\u540c\u6761\u4ef6\u5b57\u6bb5,\u6761\u4ef6\u5c06\u4f1a\u88ab\u8986\u76d6,{}-{}", new Object[]{field, whereOperation});
        }
        fieldMap.put(whereOperation, val);
    }

    protected Map<WhereOperation, Object> getFieldMap(Object field) {
        Map map = this.whereMap.getOrDefault(field, new ConcurrentHashMap());
        if (!this.whereMap.containsKey(field)) {
            this.whereMap.put(field, map);
        }
        return map;
    }

    public Map<Object, Map<WhereOperation, Object>> getWhereMap() {
        return this.whereMap;
    }

    public List<BaseWhereQuery<T, F, ?>> getOrList() {
        return this.orList;
    }

    public QueryInfo buildQueryInfo() {
        List<QueryItem> andList = this.whereMap.entrySet().stream().map(it -> {
            Object key = it.getKey();
            QueryItem queryItem = new QueryItem();
            FieldInfo fieldInfo = null;
            fieldInfo = this.parseFieldInfo(key);
            queryItem.setField(fieldInfo);
            queryItem.setVal((Map)it.getValue());
            return queryItem;
        }).collect(Collectors.toList());
        List<QueryInfo> collect = this.orList.stream().map(BaseWhereQuery::buildQueryInfo).collect(Collectors.toList());
        QueryInfo queryInfo = new QueryInfo();
        queryInfo.setAnd(andList);
        queryInfo.setOr(collect);
        return queryInfo;
    }

    public Map<FieldInfo, OrderType> getOrderMap() {
        return this.orderMap;
    }

    @Override
    public C select(F ... fields) {
        List list = Arrays.stream(fields).map(this::parseFieldInfo).collect(Collectors.toList());
        this.selectList.addAll(list);
        return this.returnObj;
    }

    @Override
    public C exclude(F ... fields) {
        List list = Arrays.stream(fields).map(this::parseFieldInfo).collect(Collectors.toList());
        this.excludeList.addAll(list);
        return this.returnObj;
    }

    public List<FieldInfo> getSelectList() {
        return this.selectList;
    }

    public List<FieldInfo> getExcludeList() {
        return this.excludeList;
    }

    private FieldInfo parseFieldInfo(Object key) {
        FieldInfo fieldInfo;
        if (key instanceof String) {
            fieldInfo = new FieldInfo((String)key);
        } else if (key instanceof CascadeField) {
            fieldInfo = ((CascadeField)key).getFieldInfo();
        } else if (key instanceof FieldFunction) {
            fieldInfo = LambdaTool.getFieldInfo((FieldFunction)key);
        } else if (key instanceof FieldInfo) {
            fieldInfo = (FieldInfo)key;
        } else {
            throw new LambdaQueryException("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        return fieldInfo;
    }
}

