/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.core.base;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ReflectUtil;
import com.github.xuejike.query.core.JLambdaQuery;
import com.github.xuejike.query.core.JQuerys;
import com.github.xuejike.query.core.base.BaseDao;
import com.github.xuejike.query.core.criteria.DaoCriteria;
import com.github.xuejike.query.core.criteria.GetDaoCriteria;
import com.github.xuejike.query.core.criteria.IJPage;
import com.github.xuejike.query.core.criteria.SelectDaoCriteria;
import com.github.xuejike.query.core.po.FieldInfo;
import com.github.xuejike.query.core.po.JPage;
import com.github.xuejike.query.core.po.LoadRefInfo;
import com.github.xuejike.query.core.tool.ELParseTool;
import com.github.xuejike.query.core.tool.lambda.CascadeField;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDao<T, R>
implements SelectDaoCriteria<R>,
GetDaoCriteria<T> {
    private static final Logger log = LoggerFactory.getLogger(MapDao.class);
    private BaseDao<T, ?> daoCriteria;
    private Class<R> resultCls;

    public MapDao(BaseDao<T, ?> daoCriteria, Class<R> resultCls) {
        this.daoCriteria = daoCriteria;
        this.resultCls = resultCls;
    }

    @Override
    public DaoCriteria<T> getDao() {
        return this.daoCriteria;
    }

    @Override
    public List<R> list() {
        List<T> list = this.getDao().list();
        List<R> collect = this.loadRefMap(list);
        return collect;
    }

    private List<R> loadRefMap(List<T> list) {
        Map<FieldInfo, LoadRefInfo<?>> refClassMap = this.daoCriteria.getRefClassMap();
        log.debug("loadRefMap \u8017\u65f6\u7edf\u8ba1:\u52a0\u8f7d\u5f15\u7528\u5bf9\u8c61{}:", (Object)refClassMap.size());
        long begin = System.currentTimeMillis();
        ConcurrentHashMap refMap = new ConcurrentHashMap(refClassMap.size());
        refClassMap.entrySet().parallelStream().forEach(entry -> {
            Set refIdList = list.stream().map(it -> ReflectUtil.getFieldValue((Object)it, (String)((FieldInfo)entry.getKey()).getField())).collect(Collectors.toSet());
            List refList = ((JLambdaQuery)JQuerys.lambdaQuery(((LoadRefInfo)entry.getValue()).getRefClass()).in((Object)new CascadeField().subFieldName(((LoadRefInfo)entry.getValue()).getTargetField().getField()), (Collection)refIdList)).list();
            Map<Object, Object> map = refList.stream().collect(Collectors.toMap(it -> ReflectUtil.getFieldValue((Object)it, (String)((LoadRefInfo)entry.getValue()).getTargetField().getField()), it -> it));
            log.debug("loadRefMap \u8017\u65f6\u7edf\u8ba1:\u5173\u8054\u5c5e\u6027{},\u52a0\u8f7d\u8017\u65f6:{}ms", (Object)((FieldInfo)entry.getKey()).getField(), (Object)(System.currentTimeMillis() - begin));
            refMap.put(((FieldInfo)entry.getKey()).getField(), map);
        });
        log.debug("loadRefMap \u8017\u65f6\u7edf\u8ba1:\u5173\u8054\u5c5e\u6027\u52a0\u8f7d\u603b\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - begin));
        long elBegin = System.currentTimeMillis();
        List collect = list.parallelStream().map(item -> {
            Object r = BeanUtil.copyProperties((Object)item, this.resultCls, (String[])new String[0]);
            HashMap varMap = new HashMap();
            for (Map.Entry entry2 : refMap.entrySet()) {
                String varName = ELParseTool.getSetRefValue(this.resultCls, (String)entry2.getKey());
                Object varValue = ((Map)entry2.getValue()).get(ReflectUtil.getFieldValue((Object)item, (String)((String)entry2.getKey())));
                varMap.put(varName, varValue);
            }
            Map<Field, String> fieldStringMap = ELParseTool.getRefValues(this.resultCls);
            fieldStringMap.entrySet().parallelStream().forEach(entry -> ReflectUtil.setFieldValue((Object)r, (Field)((Field)entry.getKey()), ELParseTool.parseEl((String)entry.getValue(), varMap, ((Field)entry.getKey()).getType())));
            return r;
        }).collect(Collectors.toList());
        log.debug("loadRefMap \u8017\u65f6\u7edf\u8ba1:\u5408\u5e76\u6570\u636e\u603b\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - elBegin));
        log.debug("loadRefMap \u8017\u65f6\u7edf\u8ba1:\u603b\u8017\u65f6:{}ms", (Object)(System.currentTimeMillis() - begin));
        return collect;
    }

    @Override
    public R getFirst() {
        T first = this.getDao().getFirst();
        if (first == null) {
            return null;
        }
        List<R> rs = this.loadRefMap(ListUtil.of((Object[])new Object[]{first}));
        return rs.get(0);
    }

    @Override
    public Optional<R> getFirstStream() {
        return Optional.ofNullable(this.getFirst());
    }

    @Override
    public IJPage<R> page(IJPage<R> page) {
        IJPage<T> rPage = this.getDao().page(new JPage(page.getPageNo(), page.getPageSize(), page.isHaveTotal()));
        List<R> rs = this.loadRefMap(rPage.getData());
        page.setData(rs);
        page.setTotal(rPage.getTotal());
        return page;
    }

    @Override
    public R findById(Serializable id) {
        T rs = this.getDao().findById(id);
        if (rs == null) {
            return null;
        }
        List<R> list = this.loadRefMap(ListUtil.of((Object[])new Object[]{rs}));
        return list.get(0);
    }

    @Override
    public Optional<R> findByIdStream(Serializable id) {
        return Optional.ofNullable(this.findById(id));
    }
}

