/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.core.tool;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.LFUCache;
import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.lang.SimpleCache;
import cn.hutool.core.util.ReflectUtil;
import com.github.xuejike.query.core.annotation.RefValue;
import com.github.xuejike.query.core.annotation.SetRefValue;
import com.github.xuejike.query.core.exception.LambdaQueryException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ELParseTool {
    static ExpressionParser spelExpressionParser = new SpelExpressionParser();
    static LFUCache<String, Expression> expCache = CacheUtil.newLFUCache((int)300);
    static SimpleCache<String, String> setRefValueCache = new SimpleCache();
    static SimpleCache<Class<?>, Map<Field, String>> refValueCache = new SimpleCache();

    public static <T> T parseEl(String expStr, Map<String, Object> varMap, Class<T> returnCls) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (Map.Entry<String, Object> entry : varMap.entrySet()) {
            context.setVariable(entry.getKey(), entry.getValue());
        }
        Expression expression = (Expression)expCache.get((Object)expStr, () -> spelExpressionParser.parseExpression(expStr));
        return (T)expression.getValue((EvaluationContext)context, returnCls);
    }

    public static String getSetRefValue(Class<?> voCls, String fieldName) {
        return (String)setRefValueCache.get((Object)(voCls.getName() + "_" + fieldName), () -> {
            Field field = ReflectUtil.getField((Class)voCls, (String)fieldName);
            SetRefValue annotation = (SetRefValue)AnnotationUtil.getAnnotation((AnnotatedElement)field, SetRefValue.class);
            if (annotation == null) {
                throw new LambdaQueryException("{} -> {} \u672a\u8bbe\u7f6e @SetRefValue", voCls.getName(), fieldName);
            }
            return annotation.value();
        });
    }

    public static Map<Field, String> getRefValues(Class<?> voCls) {
        return (Map)refValueCache.get(voCls, () -> {
            Field[] fields = ReflectUtil.getFields((Class)voCls);
            ConcurrentHashMap<Field, String> map = new ConcurrentHashMap<Field, String>(fields.length);
            for (Field field : fields) {
                RefValue refValue = (RefValue)AnnotationUtil.getAnnotation((AnnotatedElement)field, RefValue.class);
                if (refValue == null) continue;
                field.setAccessible(true);
                map.put(field, refValue.value());
            }
            return map;
        });
    }

    public static void parseRefValue(Class<?> voCls) {
        Field[] fields = ReflectUtil.getFields(voCls);
        ConcurrentHashMap<String, String> fieldElMap = new ConcurrentHashMap<String, String>(5);
        for (Field field : fields) {
            RefValue value = (RefValue)AnnotationUtil.getAnnotation((AnnotatedElement)field, RefValue.class);
            if (value == null) continue;
            fieldElMap.put(field.getName(), value.value());
        }
    }
}

