package com.github.xuejike.query.dataverse.annotation;

import com.github.xuejike.query.core.annotation.DaoSelect;
import com.github.xuejike.query.dataverse.DataverseDao;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to mark a Java class as a Dataverse entity.
 * This annotation is used to configure the entity name, primary key, and environment
 * for querying Microsoft Dataverse tables.
 *
 * @author xuejike
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@DaoSelect(daoCls = DataverseDao.class)
public @interface DataverseDaoSelect {
    
    /**
     * Dataverse entity logical name (e.g., "account", "contact")
     * This is the logical name of the table in Dataverse.
     *
     * @return the entity logical name
     */
    String entityName();
    
    /**
     * Primary key field name. If not specified, defaults to entityName + "id"
     * For example, for entity "account", the default primary key would be "accountid"
     *
     * @return the primary key field name
     */
    String primaryKey() default "";
    
    /**
     * Environment name for multi-environment configuration.
     * Defaults to "default" environment.
     *
     * @return the environment name
     */
    String environment() default "default";
}
