package com.github.xuejike.query.dataverse.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to mark a field that should be populated with the formatted value
 * from Dataverse. Dataverse returns formatted values for certain field types
 * (like lookups, option sets, dates) in the @OData.Community.Display.V1.FormattedValue annotation.
 *
 * @author xuejike
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface FormattedValue {
    
    /**
     * The source field name whose formatted value should be used.
     * If empty, uses the current field name.
     *
     * @return the source field name
     */
    String sourceField() default "";
}
