package com.github.xuejike.query.dataverse.auth;

/**
 * Interface for Dataverse authentication providers.
 * Implementations of this interface handle obtaining and managing access tokens
 * for authenticating with Microsoft Dataverse.
 *
 * @author xuejike
 */
public interface DataverseAuthProvider {
    
    /**
     * Get a valid access token for Dataverse API calls.
     * This method should handle token caching and automatic refresh.
     *
     * @return a valid access token
     * @throws RuntimeException if authentication fails
     */
    String getAccessToken();
    
    /**
     * Refresh the access token.
     * This method should be called when the current token has expired.
     *
     * @return a new access token
     * @throws RuntimeException if token refresh fails
     */
    String refreshToken();
    
    /**
     * Check if the current token is expired or about to expire.
     *
     * @return true if the token needs to be refreshed
     */
    boolean isTokenExpired();
}
