package com.github.xuejike.query.dataverse.client;

import lombok.Data;

/**
 * Represents an OData query with all its components.
 * Used to build OData v4.0 query URLs for Dataverse.
 *
 * @author xuejike
 */
@Data
public class ODataQuery {
    
    /**
     * The entity name (table logical name)
     */
    private String entityName;
    
    /**
     * The $filter clause
     */
    private String filter;
    
    /**
     * The $select clause (comma-separated field names)
     */
    private String select;
    
    /**
     * The $orderby clause
     */
    private String orderBy;
    
    /**
     * The $expand clause for related entities
     */
    private String expand;
    
    /**
     * The $top parameter (limit)
     */
    private int top;
    
    /**
     * The $skip parameter (offset)
     * 注意: Dataverse不支持$skip参数（错误代码0x80060888），此字段已废弃
     * @deprecated Dataverse does not support $skip parameter. Use @odata.nextLink for pagination instead.
     */
    @Deprecated
    private int skip;
    
    /**
     * Whether to include $count=true
     */
    private boolean count;
    
    /**
     * Create a new ODataQuery for the specified entity.
     *
     * @param entityName the entity logical name
     */
    public ODataQuery(String entityName) {
        this.entityName = entityName;
    }
    
    /**
     * Create an empty ODataQuery.
     */
    public ODataQuery() {
    }
}
