package com.github.xuejike.query.dataverse.client;

import com.alibaba.fastjson.JSONArray;
import lombok.Data;

/**
 * Represents an OData response from Dataverse.
 * Contains the result values, pagination link, and optional count.
 *
 * @author xuejike
 */
@Data
public class ODataResponse {
    
    /**
     * The array of result values
     */
    private JSONArray value;
    
    /**
     * The next link for pagination (if more results exist)
     */
    private String nextLink;
    
    /**
     * The total count (if $count=true was requested)
     */
    private Long count;
    
    /**
     * Create an empty ODataResponse.
     */
    public ODataResponse() {
    }
}
