package com.github.xuejike.query.dataverse.config;

import lombok.Data;

/**
 * Configuration for a single Dataverse environment.
 * Contains the environment URL and authentication settings.
 *
 * @author xuejike
 */
@Data
public class DataverseEnvironment {
    
    /**
     * The Dataverse environment URL (e.g., "https://org.crm.dynamics.com")
     */
    private String url;
    
    /**
     * Authentication configuration
     */
    private AuthConfig auth = new AuthConfig();
    
    /**
     * Authentication configuration.
     */
    @Data
    public static class AuthConfig {
        /**
         * Authentication type (e.g., "oauth2", "service-principal")
         */
        private String type = "oauth2";
        
        /**
         * Azure AD application (client) ID
         */
        private String clientId;
        
        /**
         * Client secret
         */
        private String clientSecret;
        
        /**
         * Azure AD tenant ID
         */
        private String tenantId;
        
        /**
         * OAuth scope (e.g., "https://org.crm.dynamics.com/.default")
         */
        private String scope;
    }
}
