package com.github.xuejike.query.dataverse.exception;

import com.github.xuejike.query.core.exception.LambdaQueryException;

/**
 * Dataverse查询异常
 * 当OData查询无效或执行失败时抛出
 *
 * @author xuejike
 */
public class DataverseQueryException extends LambdaQueryException {
    
    private final String query;
    
    public DataverseQueryException(String message, String query) {
        super(message + " (Query: " + query + ")");
        this.query = query;
    }
    
    public DataverseQueryException(String message, String query, Throwable cause) {
        super(message + " (Query: " + query + ")", cause);
        this.query = query;
    }
    
    public String getQuery() {
        return query;
    }
}
