package com.github.xuejike.query.dataverse.exception;

/**
 * 实体未找到异常
 * 当请求的Dataverse实体不存在时抛出
 *
 * @author xuejike
 */
public class EntityNotFoundException extends DataverseQueryException {
    
    private final String entityName;
    
    public EntityNotFoundException(String entityName, String query) {
        super("Entity not found: " + entityName, query);
        this.entityName = entityName;
    }
    
    public String getEntityName() {
        return entityName;
    }
}
