package com.github.xuejike.query.dataverse.metadata;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents metadata for a Dataverse entity (table).
 * Contains information about the entity structure, fields, and relationships.
 *
 * @author xuejike
 */
@Data
public class EntityMetadata {
    
    /**
     * The logical name of the entity
     */
    private String logicalName;
    
    /**
     * The display name of the entity
     */
    private String displayName;
    
    /**
     * The primary ID attribute name
     */
    private String primaryIdAttribute;
    
    /**
     * The primary name attribute (display field)
     */
    private String primaryNameAttribute;
    
    /**
     * List of field metadata
     */
    private List<FieldMetadata> fields = new ArrayList<>();
    
    /**
     * Create an empty EntityMetadata.
     */
    public EntityMetadata() {
    }
    
    /**
     * Get field metadata by logical name.
     *
     * @param logicalName the field logical name
     * @return the field metadata, or null if not found
     */
    public FieldMetadata getField(String logicalName) {
        return fields.stream()
                .filter(f -> f.getLogicalName().equals(logicalName))
                .findFirst()
                .orElse(null);
    }
}
