package com.github.xuejike.query.dataverse.metadata;

import lombok.Data;

import java.util.ArrayList;
import java.util.List;

/**
 * Represents metadata for a Dataverse field (attribute).
 * Contains information about the field type, constraints, and relationships.
 *
 * @author xuejike
 */
@Data
public class FieldMetadata {
    
    /**
     * The logical name of the field
     */
    private String logicalName;
    
    /**
     * The display name of the field
     */
    private String displayName;
    
    /**
     * The attribute type (e.g., "String", "Integer", "Lookup", "DateTime")
     */
    private String attributeType;
    
    /**
     * Whether the field is required
     */
    private boolean isRequired;
    
    /**
     * Maximum length (for string fields)
     */
    private Integer maxLength;
    
    /**
     * Precision (for decimal/money fields)
     */
    private Integer precision;
    
    /**
     * Scale (for decimal fields)
     */
    private Integer scale;
    
    /**
     * Minimum value (for numeric fields)
     */
    private Double minValue;
    
    /**
     * Maximum value (for numeric fields)
     */
    private Double maxValue;
    
    /**
     * Target entity names for lookup fields
     */
    private List<String> lookupTargets = new ArrayList<>();
    
    /**
     * Whether this is a primary key field
     */
    private boolean isPrimaryKey;
    
    /**
     * Create an empty FieldMetadata.
     */
    public FieldMetadata() {
    }
}
