/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.xuejike.query.core.base.BaseDao;
import com.github.xuejike.query.core.criteria.IJPage;
import com.github.xuejike.query.core.exception.LambdaQueryException;
import com.github.xuejike.query.core.po.QueryInfo;
import com.github.xuejike.query.dataverse.DataverseQueryBuilder;
import com.github.xuejike.query.dataverse.annotation.DataverseField;
import com.github.xuejike.query.dataverse.annotation.FormattedValue;
import com.github.xuejike.query.dataverse.client.DataverseClient;
import com.github.xuejike.query.dataverse.client.ODataQuery;
import com.github.xuejike.query.dataverse.client.ODataResponse;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataverseDao<T>
extends BaseDao<T, ODataQuery> {
    private static final Logger log = LoggerFactory.getLogger(DataverseDao.class);
    private final DataverseClient client;
    private final String entityName;
    private final String primaryKey;

    public DataverseDao(DataverseClient client, Class<T> entityCls, String entityName, String primaryKey) {
        super(entityCls);
        this.client = client;
        this.entityName = entityName;
        this.primaryKey = primaryKey;
    }

    public ODataQuery buildQuery() {
        ODataQuery query = new ODataQuery(this.entityName);
        if (this.baseWhereQuery != null) {
            QueryInfo queryInfo = this.baseWhereQuery.buildQueryInfo();
            if (queryInfo != null) {
                DataverseQueryBuilder.buildFilter(query, queryInfo, this.entityCls);
            }
            DataverseQueryBuilder.buildSelect(query, this.baseWhereQuery.getSelectList(), this.entityCls);
            if (CollUtil.isNotEmpty((Map)this.baseWhereQuery.getOrderMap())) {
                DataverseQueryBuilder.buildOrderBy(query, this.baseWhereQuery.getOrderMap(), this.entityCls);
            }
        }
        if (this.baseConditionsVo != null) {
            if (this.baseConditionsVo.getWhere() != null) {
                DataverseQueryBuilder.buildFilter(query, this.baseConditionsVo.getWhere(), this.entityCls);
            }
            if (CollUtil.isNotEmpty((Collection)this.baseConditionsVo.getSelectList())) {
                DataverseQueryBuilder.buildSelect(query, this.baseConditionsVo.getSelectList(), this.entityCls);
            }
            if (CollUtil.isNotEmpty((Map)this.baseConditionsVo.getOrderMap())) {
                DataverseQueryBuilder.buildOrderBy(query, this.baseConditionsVo.getOrderMap(), this.entityCls);
            }
        }
        this.buildExpandForLookupFields(query);
        return query;
    }

    private void buildExpandForLookupFields(ODataQuery query) {
        Field[] fields;
        ArrayList<String> expandFields = new ArrayList<String>();
        for (Field field : fields = this.entityCls.getDeclaredFields()) {
            String fieldName;
            String navigationProperty;
            DataverseField annotation = field.getAnnotation(DataverseField.class);
            if (annotation == null || !annotation.lookup() || !StrUtil.isNotBlank((CharSequence)(navigationProperty = this.extractNavigationProperty(fieldName = annotation.value())))) continue;
            expandFields.add(navigationProperty);
        }
        if (!expandFields.isEmpty()) {
            String expand = String.join((CharSequence)",", expandFields);
            query.setExpand(expand);
            log.debug("Auto-detected lookup fields for expand: {}", (Object)expand);
        }
    }

    private String extractNavigationProperty(String lookupFieldName) {
        if (StrUtil.isBlank((CharSequence)lookupFieldName)) {
            return null;
        }
        if (lookupFieldName.startsWith("_") && lookupFieldName.endsWith("_value")) {
            return lookupFieldName.substring(1, lookupFieldName.length() - 6);
        }
        return lookupFieldName;
    }

    public List<T> list() {
        ODataQuery query = this.buildQuery();
        ArrayList<T> results = new ArrayList<T>();
        String nextLink = null;
        do {
            ODataResponse response;
            if ((response = this.client.execute(query, nextLink)) == null) {
                log.warn("Received null response from Dataverse client");
                break;
            }
            List<T> pageResults = this.parseResponse(response);
            results.addAll(pageResults);
            nextLink = response.getNextLink();
            log.debug("Retrieved {} records, nextLink={}", (Object)pageResults.size(), (Object)(nextLink != null ? "present" : "null"));
        } while (nextLink != null);
        log.debug("Total records retrieved: {}", (Object)results.size());
        return results;
    }

    public T getFirst() {
        ODataQuery query = this.buildQuery();
        query.setTop(1);
        ODataResponse response = this.client.execute(query, null);
        List<T> results = this.parseResponse(response);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    public Long count() {
        ODataQuery query = this.buildQuery();
        query.setCount(true);
        query.setTop(0);
        ODataResponse response = this.client.execute(query, null);
        if (response.getCount() != null) {
            return response.getCount();
        }
        log.warn("Count not returned in response, falling back to value array size");
        return response.getValue() != null ? (long)response.getValue().size() : 0L;
    }

    public IJPage<T> page(IJPage<T> page) {
        if (page.getPageNo() > 0) {
            throw new UnsupportedOperationException("Dataverse\u4e0d\u652f\u6301$skip\u53c2\u6570\uff0c\u65e0\u6cd5\u8df3\u8f6c\u5230\u6307\u5b9a\u9875\u7801\u3002\u8bf7\u4f7f\u7528list()\u65b9\u6cd5\u83b7\u53d6\u6240\u6709\u6570\u636e\uff08\u4f1a\u81ea\u52a8\u8ddf\u968f@odata.nextLink\u5206\u9875\uff09\uff0c\u6216\u4ec5\u67e5\u8be2\u7b2c\u4e00\u9875\uff08pageNo=0\uff09\u3002\u5f53\u524d\u8bf7\u6c42: pageNo=" + page.getPageNo());
        }
        ODataQuery query = this.buildQuery();
        query.setTop(page.getPageSize());
        if (page.isHaveTotal()) {
            query.setCount(true);
        }
        ODataResponse response = this.client.execute(query, null);
        if (page.isHaveTotal() && response.getCount() != null) {
            page.setTotal(response.getCount().longValue());
        }
        List<T> results = this.parseResponse(response);
        page.setData(results);
        log.debug("Page query: pageNo={}, pageSize={}, total={}, resultSize={}", new Object[]{page.getPageNo(), page.getPageSize(), page.getTotal(), results.size()});
        return page;
    }

    public T findById(Serializable id) {
        if (id == null) {
            throw new IllegalArgumentException("ID cannot be null");
        }
        String entityPath = String.format("%s(%s)", this.entityName, this.formatIdForUrl(id));
        ODataResponse response = this.client.get(entityPath);
        List<T> results = this.parseResponse(response);
        if (results.isEmpty()) {
            return null;
        }
        return results.get(0);
    }

    private String formatIdForUrl(Serializable id) {
        String idStr = id.toString();
        if (idStr.matches("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}")) {
            return idStr;
        }
        return "'" + idStr + "'";
    }

    private List<T> parseResponse(ODataResponse response) {
        if (response == null || response.getValue() == null) {
            return new ArrayList();
        }
        JSONArray valueArray = response.getValue();
        ArrayList<T> results = new ArrayList<T>(valueArray.size());
        for (int i = 0; i < valueArray.size(); ++i) {
            JSONObject jsonObject = valueArray.getJSONObject(i);
            T entity = this.mapJsonToEntity(jsonObject);
            results.add(entity);
        }
        return results;
    }

    private T mapJsonToEntity(JSONObject jsonObject) {
        try {
            Field[] fields;
            Object entity = this.entityCls.newInstance();
            for (Field field : fields = this.entityCls.getDeclaredFields()) {
                boolean isLookupField;
                field.setAccessible(true);
                FormattedValue formattedValueAnnotation = field.getAnnotation(FormattedValue.class);
                if (formattedValueAnnotation != null) {
                    String formattedKey;
                    String sourceField = formattedValueAnnotation.sourceField();
                    if (StrUtil.isBlank((CharSequence)sourceField)) {
                        sourceField = field.getName();
                    }
                    if (!jsonObject.containsKey((Object)(formattedKey = sourceField + "@OData.Community.Display.V1.FormattedValue"))) continue;
                    Object formattedValue = jsonObject.get((Object)formattedKey);
                    this.setFieldValue(field, entity, formattedValue);
                    continue;
                }
                String dataverseFieldName = this.getDataverseFieldName(field);
                DataverseField dataverseFieldAnnotation = field.getAnnotation(DataverseField.class);
                boolean bl = isLookupField = dataverseFieldAnnotation != null && dataverseFieldAnnotation.lookup();
                if (!jsonObject.containsKey((Object)dataverseFieldName)) continue;
                Object value = jsonObject.get((Object)dataverseFieldName);
                if (value == null && isLookupField) {
                    this.setFieldValue(field, entity, null);
                    continue;
                }
                if (isLookupField && value instanceof JSONObject) {
                    JSONObject lookupObject = (JSONObject)value;
                    Object lookupId = this.extractLookupId(lookupObject);
                    this.setFieldValue(field, entity, lookupId);
                    continue;
                }
                this.setFieldValue(field, entity, value);
            }
            return entity;
        }
        catch (Exception e) {
            log.error("Failed to map JSON to entity: {}", (Object)e.getMessage(), (Object)e);
            throw new LambdaQueryException("Failed to map JSON to entity", (Throwable)e);
        }
    }

    private Object extractLookupId(JSONObject lookupObject) {
        String[] idFieldNames;
        for (String idFieldName : idFieldNames = new String[]{"id", lookupObject.keySet().stream().filter(key -> key.endsWith("id")).findFirst().orElse(null)}) {
            if (idFieldName == null || !lookupObject.containsKey((Object)idFieldName)) continue;
            return lookupObject.get((Object)idFieldName);
        }
        log.warn("Could not find ID field in lookup object, available keys: {}", (Object)lookupObject.keySet());
        return lookupObject.toJSONString();
    }

    private String getDataverseFieldName(Field field) {
        DataverseField annotation = field.getAnnotation(DataverseField.class);
        if (annotation != null && StrUtil.isNotBlank((CharSequence)annotation.value())) {
            return annotation.value();
        }
        return field.getName();
    }

    private void setFieldValue(Field field, T entity, Object value) {
        try {
            if (value == null) {
                field.set(entity, null);
                return;
            }
            Class<?> fieldType = field.getType();
            if (fieldType == String.class) {
                field.set(entity, value.toString());
            } else if (fieldType == Integer.class || fieldType == Integer.TYPE) {
                field.set(entity, ((Number)value).intValue());
            } else if (fieldType == Long.class || fieldType == Long.TYPE) {
                field.set(entity, ((Number)value).longValue());
            } else if (fieldType == Double.class || fieldType == Double.TYPE) {
                field.set(entity, ((Number)value).doubleValue());
            } else if (fieldType == Boolean.class || fieldType == Boolean.TYPE) {
                field.set(entity, Boolean.parseBoolean(value.toString()));
            } else {
                field.set(entity, Convert.convert(fieldType, (Object)value, (Object)value));
            }
        }
        catch (Exception e) {
            log.warn("Failed to set field {}: {}", (Object)field.getName(), (Object)e.getMessage());
        }
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }
}

