/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse;

import cn.hutool.core.util.StrUtil;
import com.github.xuejike.query.core.base.BaseDao;
import com.github.xuejike.query.core.config.DaoFactory;
import com.github.xuejike.query.core.exception.LambdaQueryException;
import com.github.xuejike.query.dataverse.DataverseDao;
import com.github.xuejike.query.dataverse.annotation.DataverseDaoSelect;
import com.github.xuejike.query.dataverse.client.DataverseClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataverseDaoFactory
extends DaoFactory {
    private static final Logger log = LoggerFactory.getLogger(DataverseDaoFactory.class);
    private final Map<String, DataverseClient> clients;
    private static final String DEFAULT_ENVIRONMENT = "default";

    public DataverseDaoFactory(DataverseClient defaultClient) {
        super(DataverseDao.class);
        this.clients = new HashMap<String, DataverseClient>();
        this.clients.put(DEFAULT_ENVIRONMENT, defaultClient);
        log.info("DataverseDaoFactory initialized with default client");
    }

    public DataverseDaoFactory(Map<String, DataverseClient> clients) {
        super(DataverseDao.class);
        if (clients == null || clients.isEmpty()) {
            throw new IllegalArgumentException("Clients map cannot be null or empty");
        }
        this.clients = new HashMap<String, DataverseClient>(clients);
        log.info("DataverseDaoFactory initialized with {} environments", (Object)clients.size());
    }

    public <T> BaseDao<T, ?> createDao(Class<T> entityCls) {
        DataverseDaoSelect annotation = entityCls.getAnnotation(DataverseDaoSelect.class);
        if (annotation == null) {
            throw new LambdaQueryException("Class " + entityCls.getName() + " is not annotated with @DataverseDaoSelect", new Object[0]);
        }
        String entityName = this.extractEntityName(entityCls);
        String primaryKey = this.extractPrimaryKey(entityCls);
        String environment = this.extractEnvironment(entityCls);
        DataverseClient client = this.getClientForEnvironment(environment);
        log.debug("Creating DataverseDao for entity={}, primaryKey={}, environment={}", new Object[]{entityName, primaryKey, environment});
        return new DataverseDao<T>(client, entityCls, entityName, primaryKey);
    }

    protected DataverseClient getClientForEnvironment(String environment) {
        DataverseClient client = this.clients.get(environment);
        if (client == null) {
            throw new LambdaQueryException("No DataverseClient configured for environment: " + environment + ". Available environments: " + this.clients.keySet(), new Object[0]);
        }
        return client;
    }

    public void addClient(String environment, DataverseClient client) {
        if (StrUtil.isBlank((CharSequence)environment)) {
            throw new IllegalArgumentException("Environment name cannot be blank");
        }
        if (client == null) {
            throw new IllegalArgumentException("Client cannot be null");
        }
        this.clients.put(environment, client);
        log.info("Added DataverseClient for environment: {}", (Object)environment);
    }

    protected String extractEntityName(Class<?> entityCls) {
        DataverseDaoSelect annotation = entityCls.getAnnotation(DataverseDaoSelect.class);
        if (annotation == null) {
            throw new LambdaQueryException("Class " + entityCls.getName() + " is not annotated with @DataverseDaoSelect", new Object[0]);
        }
        String entityName = annotation.entityName();
        if (StrUtil.isBlank((CharSequence)entityName)) {
            throw new LambdaQueryException("entityName in @DataverseDaoSelect cannot be blank for class " + entityCls.getName(), new Object[0]);
        }
        return entityName;
    }

    protected String extractPrimaryKey(Class<?> entityCls) {
        DataverseDaoSelect annotation = entityCls.getAnnotation(DataverseDaoSelect.class);
        if (annotation == null) {
            throw new LambdaQueryException("Class " + entityCls.getName() + " is not annotated with @DataverseDaoSelect", new Object[0]);
        }
        String primaryKey = annotation.primaryKey();
        if (StrUtil.isBlank((CharSequence)primaryKey)) {
            primaryKey = annotation.entityName() + "id";
        }
        return primaryKey;
    }

    protected String extractEnvironment(Class<?> entityCls) {
        DataverseDaoSelect annotation = entityCls.getAnnotation(DataverseDaoSelect.class);
        if (annotation == null) {
            throw new LambdaQueryException("Class " + entityCls.getName() + " is not annotated with @DataverseDaoSelect", new Object[0]);
        }
        String environment = annotation.environment();
        if (StrUtil.isBlank((CharSequence)environment)) {
            environment = DEFAULT_ENVIRONMENT;
        }
        return environment;
    }

    public Set<String> getEnvironments() {
        return this.clients.keySet();
    }
}

