/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import com.github.xuejike.query.core.annotation.RefValue;
import com.github.xuejike.query.core.enums.OrderType;
import com.github.xuejike.query.core.enums.WhereOperation;
import com.github.xuejike.query.core.po.BetweenObj;
import com.github.xuejike.query.core.po.FieldInfo;
import com.github.xuejike.query.core.po.QueryInfo;
import com.github.xuejike.query.core.po.QueryItem;
import com.github.xuejike.query.dataverse.annotation.DataverseField;
import com.github.xuejike.query.dataverse.client.ODataQuery;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataverseQueryBuilder {
    private static final Logger log = LoggerFactory.getLogger(DataverseQueryBuilder.class);
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static void buildFilter(ODataQuery query, QueryInfo queryInfo, Class<?> entityClass) {
        if (queryInfo == null) {
            return;
        }
        StringBuilder filter = new StringBuilder();
        DataverseQueryBuilder.buildFilterRecursive(filter, queryInfo, entityClass);
        if (filter.length() > 0) {
            query.setFilter(filter.toString());
        }
    }

    @Deprecated
    public static void buildFilter(ODataQuery query, QueryInfo queryInfo) {
        DataverseQueryBuilder.buildFilter(query, queryInfo, null);
    }

    private static void buildFilterRecursive(StringBuilder sb, QueryInfo queryInfo, Class<?> entityClass) {
        ArrayList<String> conditions = new ArrayList<String>();
        if (CollUtil.isNotEmpty((Collection)queryInfo.getAnd())) {
            for (QueryItem item : queryInfo.getAnd()) {
                String condition = DataverseQueryBuilder.buildCondition(item, entityClass);
                if (!StrUtil.isNotBlank((CharSequence)condition)) continue;
                conditions.add(condition);
            }
        }
        if (CollUtil.isNotEmpty((Collection)queryInfo.getOr())) {
            ArrayList<String> orConditions = new ArrayList<String>();
            for (QueryInfo orQuery : queryInfo.getOr()) {
                StringBuilder orBuilder = new StringBuilder();
                DataverseQueryBuilder.buildFilterRecursive(orBuilder, orQuery, entityClass);
                if (orBuilder.length() <= 0) continue;
                orConditions.add("(" + orBuilder.toString() + ")");
            }
            if (!orConditions.isEmpty()) {
                conditions.add("(" + String.join((CharSequence)" or ", orConditions) + ")");
            }
        }
        if (!conditions.isEmpty()) {
            sb.append(String.join((CharSequence)" and ", conditions));
        }
    }

    private static String buildCondition(QueryItem item, Class<?> entityClass) {
        if (item == null || item.getField() == null || item.getVal() == null) {
            return "";
        }
        String fieldName = DataverseQueryBuilder.resolveDataverseFieldName(item.getField(), entityClass);
        Map valMap = item.getVal();
        ArrayList<String> conditions = new ArrayList<String>();
        for (Map.Entry entry : valMap.entrySet()) {
            Object value;
            WhereOperation operation = (WhereOperation)entry.getKey();
            String condition = DataverseQueryBuilder.buildOperationCondition(fieldName, operation, value = entry.getValue());
            if (!StrUtil.isNotBlank((CharSequence)condition)) continue;
            conditions.add(condition);
        }
        return String.join((CharSequence)" and ", conditions);
    }

    private static String buildOperationCondition(String fieldName, WhereOperation operation, Object value) {
        switch (operation) {
            case eq: {
                return fieldName + " eq " + DataverseQueryBuilder.formatValue(value);
            }
            case ne: {
                return fieldName + " ne " + DataverseQueryBuilder.formatValue(value);
            }
            case gt: {
                return fieldName + " gt " + DataverseQueryBuilder.formatValue(value);
            }
            case gte: {
                return fieldName + " ge " + DataverseQueryBuilder.formatValue(value);
            }
            case lt: {
                return fieldName + " lt " + DataverseQueryBuilder.formatValue(value);
            }
            case lte: {
                return fieldName + " le " + DataverseQueryBuilder.formatValue(value);
            }
            case in: {
                return DataverseQueryBuilder.buildInCondition(fieldName, value);
            }
            case notIn: {
                return "not (" + DataverseQueryBuilder.buildInCondition(fieldName, value) + ")";
            }
            case isNull: {
                return fieldName + " eq null";
            }
            case notNull: {
                return fieldName + " ne null";
            }
            case between: {
                return DataverseQueryBuilder.buildBetweenCondition(fieldName, value);
            }
        }
        log.warn("Unsupported operation: {}", (Object)operation);
        return "";
    }

    private static String buildInCondition(String fieldName, Object value) {
        List<Object> values = value instanceof Collection ? (List<Object>)value : (value.getClass().isArray() ? Arrays.asList((Object[])value) : Collections.singletonList(value));
        if (values.isEmpty()) {
            return "1 eq 0";
        }
        List conditions = values.stream().map(v -> fieldName + " eq " + DataverseQueryBuilder.formatValue(v)).collect(Collectors.toList());
        return "(" + String.join((CharSequence)" or ", conditions) + ")";
    }

    private static String buildBetweenCondition(String fieldName, Object value) {
        if (value instanceof BetweenObj) {
            BetweenObj between = (BetweenObj)value;
            return "(" + fieldName + " ge " + DataverseQueryBuilder.formatValue(between.getFirst()) + " and " + fieldName + " le " + DataverseQueryBuilder.formatValue(between.getSecond()) + ")";
        }
        if (value instanceof Object[] && ((Object[])value).length == 2) {
            Object[] range = (Object[])value;
            return "(" + fieldName + " ge " + DataverseQueryBuilder.formatValue(range[0]) + " and " + fieldName + " le " + DataverseQueryBuilder.formatValue(range[1]) + ")";
        }
        log.warn("Invalid BETWEEN value: {}", value);
        return "";
    }

    private static String formatValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            String str = value.toString().replace("'", "''");
            return "'" + str + "'";
        }
        if (value instanceof Date) {
            return ISO_DATE_FORMAT.format((Date)value);
        }
        if (value instanceof Boolean) {
            return value.toString().toLowerCase();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        return value.toString();
    }

    public static void buildSelect(ODataQuery query, List<FieldInfo> selectList, Class<?> entityClass) {
        List<FieldInfo> fieldsToSelect = selectList;
        if (CollUtil.isEmpty(selectList) && entityClass != null) {
            fieldsToSelect = DataverseQueryBuilder.extractAllFieldsFromEntity(entityClass);
        }
        if (CollUtil.isEmpty(fieldsToSelect)) {
            return;
        }
        String select = fieldsToSelect.stream().map(fieldInfo -> DataverseQueryBuilder.resolveDataverseFieldName(fieldInfo, entityClass)).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(","));
        if (StrUtil.isNotBlank((CharSequence)select)) {
            query.setSelect(select);
        }
    }

    public static void buildSelect(ODataQuery query, List<FieldInfo> selectList) {
        DataverseQueryBuilder.buildSelect(query, selectList, null);
    }

    public static List<FieldInfo> extractAllFieldsFromEntity(Class<?> entityClass) {
        Field[] declaredFields;
        if (entityClass == null) {
            return new ArrayList<FieldInfo>();
        }
        ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
        for (Field field : declaredFields = entityClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) {
                log.debug("Skipping static field: {}", (Object)field.getName());
                continue;
            }
            if (field.isAnnotationPresent(RefValue.class)) {
                log.debug("Skipping @RefValue field: {}", (Object)field.getName());
                continue;
            }
            DataverseField annotation = field.getAnnotation(DataverseField.class);
            if (annotation != null && annotation.ignored()) {
                log.debug("Skipping ignored field: {}", (Object)field.getName());
                continue;
            }
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setField(field.getName());
            fields.add(fieldInfo);
            log.debug("Added field to extract: {} (Java field name)", (Object)field.getName());
        }
        return fields;
    }

    public static void buildOrderBy(ODataQuery query, Map<FieldInfo, OrderType> orderMap, Class<?> entityClass) {
        if (CollUtil.isEmpty(orderMap)) {
            return;
        }
        String orderBy = orderMap.entrySet().stream().map(entry -> {
            String fieldName = DataverseQueryBuilder.resolveDataverseFieldName((FieldInfo)entry.getKey(), entityClass);
            String direction = entry.getValue() == OrderType.desc ? " desc" : " asc";
            return fieldName + direction;
        }).filter(CharSequenceUtil::isNotBlank).collect(Collectors.joining(","));
        if (StrUtil.isNotBlank((CharSequence)orderBy)) {
            query.setOrderBy(orderBy);
        }
    }

    @Deprecated
    public static void buildOrderBy(ODataQuery query, Map<FieldInfo, OrderType> orderMap) {
        DataverseQueryBuilder.buildOrderBy(query, orderMap, null);
    }

    public static String resolveDataverseFieldName(FieldInfo fieldInfo, Class<?> entityClass) {
        if (fieldInfo == null || StrUtil.isBlank((CharSequence)fieldInfo.getField())) {
            return "";
        }
        String javaFieldName = fieldInfo.getField();
        if (entityClass != null) {
            try {
                Field field = entityClass.getDeclaredField(javaFieldName);
                DataverseField annotation = field.getAnnotation(DataverseField.class);
                if (annotation != null && StrUtil.isNotBlank((CharSequence)annotation.value())) {
                    log.debug("Resolved field name: {} -> {} (from @DataverseField)", (Object)javaFieldName, (Object)annotation.value());
                    return annotation.value();
                }
            }
            catch (NoSuchFieldException e) {
                log.debug("Field {} not found in class {}, using Java field name", (Object)javaFieldName, (Object)entityClass.getName());
            }
            catch (Exception e) {
                log.debug("Error resolving field annotation for {}: {}", (Object)javaFieldName, (Object)e.getMessage());
            }
        }
        if (CollUtil.isNotEmpty((Collection)fieldInfo.getSubList())) {
            StringBuilder fieldPath = new StringBuilder(javaFieldName);
            for (FieldInfo subField : fieldInfo.getSubList()) {
                fieldPath.append("/").append(DataverseQueryBuilder.resolveDataverseFieldName(subField, entityClass));
            }
            return fieldPath.toString();
        }
        log.debug("Resolved field name: {} -> {} (no annotation or entityClass)", (Object)javaFieldName, (Object)javaFieldName);
        return javaFieldName;
    }

    @Deprecated
    public static String resolveDataverseFieldName(FieldInfo fieldInfo) {
        return DataverseQueryBuilder.resolveDataverseFieldName(fieldInfo, null);
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

