/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse.auth;

import com.github.xuejike.query.dataverse.auth.DataverseAuthProvider;
import com.github.xuejike.query.dataverse.auth.TokenCache;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import java.util.Collections;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2AuthProvider
implements DataverseAuthProvider {
    private static final Logger log = LoggerFactory.getLogger(OAuth2AuthProvider.class);
    private final String clientId;
    private final String clientSecret;
    private final String tenantId;
    private final String scope;
    private final TokenCache tokenCache;
    private ConfidentialClientApplication app;

    public OAuth2AuthProvider(String clientId, String clientSecret, String tenantId, String scope, TokenCache tokenCache) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tenantId = tenantId;
        this.scope = scope;
        this.tokenCache = tokenCache;
        this.initializeApp();
    }

    private void initializeApp() {
        try {
            String authority = "https://login.microsoftonline.com/" + this.tenantId;
            this.app = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)this.clientSecret)).authority(authority)).build();
        }
        catch (Exception e) {
            log.error("Failed to initialize MSAL application", (Throwable)e);
            throw new RuntimeException("Failed to initialize OAuth2 authentication", e);
        }
    }

    @Override
    public String getAccessToken() {
        if (this.tokenCache != null && this.tokenCache.hasValidToken()) {
            return this.tokenCache.getAccessToken();
        }
        return this.acquireToken();
    }

    @Override
    public String refreshToken() {
        return this.acquireToken();
    }

    @Override
    public boolean isTokenExpired() {
        if (this.tokenCache == null) {
            return true;
        }
        return !this.tokenCache.hasValidToken();
    }

    private String acquireToken() {
        try {
            ClientCredentialParameters parameters = ClientCredentialParameters.builder(Collections.singleton(this.scope)).build();
            CompletableFuture future = this.app.acquireToken(parameters);
            IAuthenticationResult result = (IAuthenticationResult)future.get();
            String accessToken = result.accessToken();
            Date expiresOn = result.expiresOnDate();
            if (this.tokenCache != null) {
                this.tokenCache.setAccessToken(accessToken, expiresOn);
            }
            log.debug("Successfully acquired access token, expires on: {}", (Object)expiresOn);
            return accessToken;
        }
        catch (Exception e) {
            log.error("Failed to acquire access token", (Throwable)e);
            throw new RuntimeException("Failed to acquire access token", e);
        }
    }
}

