/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse.auth;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCache {
    private static final Logger log = LoggerFactory.getLogger(TokenCache.class);
    private String accessToken;
    private Date expiresOn;
    private long expirationBufferMs = 300000L;

    public TokenCache() {
    }

    public TokenCache(long expirationBufferMs) {
        this.expirationBufferMs = expirationBufferMs;
    }

    public void setAccessToken(String accessToken, Date expiresOn) {
        this.accessToken = accessToken;
        this.expiresOn = expiresOn;
        log.debug("Token cached, expires on: {}", (Object)expiresOn);
    }

    public boolean hasValidToken() {
        long expirationTime;
        boolean isValid;
        if (this.accessToken == null || this.expiresOn == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        boolean bl = isValid = now < (expirationTime = this.expiresOn.getTime() - this.expirationBufferMs);
        if (!isValid) {
            log.debug("Token expired or about to expire");
        }
        return isValid;
    }

    public void clear() {
        this.accessToken = null;
        this.expiresOn = null;
        log.debug("Token cache cleared");
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Date getExpiresOn() {
        return this.expiresOn;
    }

    public long getExpirationBufferMs() {
        return this.expirationBufferMs;
    }

    public void setExpirationBufferMs(long expirationBufferMs) {
        this.expirationBufferMs = expirationBufferMs;
    }
}

