/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse.client;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.xuejike.query.core.exception.LambdaQueryException;
import com.github.xuejike.query.dataverse.auth.DataverseAuthProvider;
import com.github.xuejike.query.dataverse.client.ODataQuery;
import com.github.xuejike.query.dataverse.client.ODataResponse;
import com.github.xuejike.query.dataverse.exception.DataverseAuthException;
import com.github.xuejike.query.dataverse.exception.DataverseConnectionException;
import com.github.xuejike.query.dataverse.exception.DataverseQueryException;
import com.github.xuejike.query.dataverse.exception.EntityNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.SocketTimeoutException;
import java.net.URLEncoder;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataverseClient {
    private static final Logger log = LoggerFactory.getLogger(DataverseClient.class);
    private final String baseUrl;
    private final DataverseAuthProvider authProvider;

    public DataverseClient(String environmentUrl, DataverseAuthProvider authProvider) {
        this.baseUrl = environmentUrl + "/api/data/v9.2/";
        this.authProvider = authProvider;
    }

    public ODataResponse execute(ODataQuery query, String nextLink) {
        String url = nextLink != null ? nextLink : this.buildUrl(query);
        return this.executeGet(url);
    }

    public ODataResponse get(String entityPath) {
        String url = this.baseUrl + entityPath;
        return this.executeGet(url);
    }

    private ODataResponse executeGet(String url) {
        return this.executeGetWithRetry(url, false);
    }

    private ODataResponse executeGetWithRetry(String url, boolean isRetry) {
        try {
            String accessToken = this.authProvider.getAccessToken();
            HttpRequest request = (HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)((HttpRequest)HttpRequest.get((String)url).header("Authorization", "Bearer " + accessToken)).header("Accept", "application/json")).header("OData-MaxVersion", "4.0")).header("OData-Version", "4.0")).header("Prefer", "odata.include-annotations=\"OData.Community.Display.V1.FormattedValue\"");
            log.debug("Executing Dataverse request: {}", (Object)url);
            log.debug("Request Token {}", (Object)accessToken);
            HttpResponse response = request.execute();
            if (!response.isOk()) {
                if (response.getStatus() == 401 && !isRetry) {
                    log.info("Token expired, attempting to refresh and retry");
                    this.authProvider.refreshToken();
                    return this.executeGetWithRetry(url, true);
                }
                this.handleError(response, url);
            }
            return this.parseResponse(response.body());
        }
        catch (Exception e) {
            if (e.getCause() instanceof SocketTimeoutException || e.getMessage() != null && e.getMessage().contains("timeout")) {
                log.error("Connection timeout: {}", (Object)url, (Object)e);
                throw new DataverseConnectionException("Connection timeout: " + url, e);
            }
            if (e instanceof LambdaQueryException) {
                throw (LambdaQueryException)e;
            }
            log.error("Dataverse query failed: {}", (Object)url, (Object)e);
            throw new DataverseConnectionException("Dataverse query failed: " + url, e);
        }
    }

    private String buildUrl(ODataQuery query) {
        StringBuilder url = new StringBuilder(this.baseUrl);
        url.append(query.getEntityName());
        ArrayList<String> params = new ArrayList<String>();
        if (StrUtil.isNotBlank((CharSequence)query.getFilter())) {
            try {
                params.add("$filter=" + URLEncoder.encode(query.getFilter(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new LambdaQueryException("Failed to encode filter parameter", (Throwable)e);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)query.getSelect())) {
            params.add("$select=" + query.getSelect());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getOrderBy())) {
            params.add("$orderby=" + query.getOrderBy());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getExpand())) {
            params.add("$expand=" + query.getExpand());
        }
        if (query.getTop() > 0) {
            params.add("$top=" + query.getTop());
        }
        if (query.isCount()) {
            params.add("$count=true");
        }
        if (!params.isEmpty()) {
            url.append("?").append(String.join((CharSequence)"&", params));
        }
        return url.toString();
    }

    private void handleError(HttpResponse response, String url) {
        String message;
        int status = response.getStatus();
        String body = response.body();
        String errorCode = null;
        String errorMessage = null;
        try {
            JSONObject json = JSON.parseObject((String)body);
            JSONObject error = json.getJSONObject("error");
            if (error != null) {
                errorCode = error.getString("code");
                errorMessage = error.getString("message");
            }
        }
        catch (Exception e) {
            log.debug("Failed to parse OData error response", (Throwable)e);
        }
        if (status == 401) {
            message = errorMessage != null ? errorMessage : "Authentication failed";
            throw new DataverseAuthException("Dataverse authentication failed [{}]: {} (URL: {})", errorCode != null ? errorCode : "401", message, url);
        }
        if (status == 403) {
            message = errorMessage != null ? errorMessage : "Access forbidden";
            throw new DataverseAuthException("Dataverse access forbidden [{}]: {} (URL: {})", errorCode != null ? errorCode : "403", message, url);
        }
        if (status == 404) {
            message = errorMessage != null ? errorMessage : "Entity not found";
            String entityName = this.extractEntityName(url);
            throw new EntityNotFoundException(entityName, url);
        }
        if (status >= 400 && status < 500) {
            message = errorMessage != null ? errorMessage : "Bad request";
            throw new DataverseQueryException(String.format("Dataverse query error [%s]: %s", errorCode != null ? errorCode : String.valueOf(status), message), url);
        }
        if (status >= 500) {
            message = errorMessage != null ? errorMessage : "Server error";
            throw new DataverseConnectionException(String.format("Dataverse server error [%s]: %s (URL: {})", errorCode != null ? errorCode : String.valueOf(status), message), url);
        }
        message = errorMessage != null ? errorMessage : "Request failed";
        throw new DataverseQueryException(String.format("Dataverse error [%s]: %s", errorCode != null ? errorCode : String.valueOf(status), message), url);
    }

    private String extractEntityName(String url) {
        try {
            String path = url.substring(this.baseUrl.length());
            int queryIndex = path.indexOf(63);
            int parenIndex = path.indexOf(40);
            if (queryIndex > 0) {
                path = path.substring(0, queryIndex);
            }
            if (parenIndex > 0) {
                path = path.substring(0, parenIndex);
            }
            return path;
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private ODataResponse parseResponse(String body) {
        try {
            log.debug("Parsing OData response: {}", (Object)body);
            JSONObject json = JSON.parseObject((String)body);
            ODataResponse response = new ODataResponse();
            JSONArray value = json.getJSONArray("value");
            if (value != null) {
                response.setValue(value);
            } else {
                JSONArray singleValue = new JSONArray();
                singleValue.add((Object)json);
                response.setValue(singleValue);
            }
            String nextLink = json.getString("@odata.nextLink");
            response.setNextLink(nextLink);
            Long count = json.getLong("@odata.count");
            response.setCount(count);
            log.debug("Parsed OData response: {} records, nextLink={}, count={}", new Object[]{response.getValue() != null ? response.getValue().size() : 0, nextLink != null ? "present" : "null", count});
            return response;
        }
        catch (Exception e) {
            log.error("Failed to parse OData response", (Throwable)e);
            throw new LambdaQueryException("Failed to parse OData response", (Throwable)e);
        }
    }
}

