/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse.config;

import com.github.xuejike.query.dataverse.config.DataverseEnvironment;
import java.util.HashMap;
import java.util.Map;

public class DataverseConfig {
    private Map<String, DataverseEnvironment> environments = new HashMap<String, DataverseEnvironment>();
    private TokenCacheConfig tokenCache = new TokenCacheConfig();
    private HttpConfig http = new HttpConfig();

    public DataverseEnvironment getEnvironment(String environmentName) {
        return this.environments.get(environmentName);
    }

    public void addEnvironment(String name, DataverseEnvironment environment) {
        this.environments.put(name, environment);
    }

    public Map<String, DataverseEnvironment> getEnvironments() {
        return this.environments;
    }

    public TokenCacheConfig getTokenCache() {
        return this.tokenCache;
    }

    public HttpConfig getHttp() {
        return this.http;
    }

    public void setEnvironments(Map<String, DataverseEnvironment> environments) {
        this.environments = environments;
    }

    public void setTokenCache(TokenCacheConfig tokenCache) {
        this.tokenCache = tokenCache;
    }

    public void setHttp(HttpConfig http) {
        this.http = http;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataverseConfig)) {
            return false;
        }
        DataverseConfig other = (DataverseConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, DataverseEnvironment> this$environments = this.getEnvironments();
        Map<String, DataverseEnvironment> other$environments = other.getEnvironments();
        if (this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments)) {
            return false;
        }
        TokenCacheConfig this$tokenCache = this.getTokenCache();
        TokenCacheConfig other$tokenCache = other.getTokenCache();
        if (this$tokenCache == null ? other$tokenCache != null : !((Object)this$tokenCache).equals(other$tokenCache)) {
            return false;
        }
        HttpConfig this$http = this.getHttp();
        HttpConfig other$http = other.getHttp();
        return !(this$http == null ? other$http != null : !((Object)this$http).equals(other$http));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataverseConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, DataverseEnvironment> $environments = this.getEnvironments();
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        TokenCacheConfig $tokenCache = this.getTokenCache();
        result = result * 59 + ($tokenCache == null ? 43 : ((Object)$tokenCache).hashCode());
        HttpConfig $http = this.getHttp();
        result = result * 59 + ($http == null ? 43 : ((Object)$http).hashCode());
        return result;
    }

    public String toString() {
        return "DataverseConfig(environments=" + this.getEnvironments() + ", tokenCache=" + this.getTokenCache() + ", http=" + this.getHttp() + ")";
    }

    public static class HttpConfig {
        private int connectTimeout = 30000;
        private int readTimeout = 60000;
        private int maxRetries = 3;

        public int getConnectTimeout() {
            return this.connectTimeout;
        }

        public int getReadTimeout() {
            return this.readTimeout;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public void setConnectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public void setReadTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
        }

        public void setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpConfig)) {
                return false;
            }
            HttpConfig other = (HttpConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getConnectTimeout() != other.getConnectTimeout()) {
                return false;
            }
            if (this.getReadTimeout() != other.getReadTimeout()) {
                return false;
            }
            return this.getMaxRetries() == other.getMaxRetries();
        }

        protected boolean canEqual(Object other) {
            return other instanceof HttpConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getConnectTimeout();
            result = result * 59 + this.getReadTimeout();
            result = result * 59 + this.getMaxRetries();
            return result;
        }

        public String toString() {
            return "DataverseConfig.HttpConfig(connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", maxRetries=" + this.getMaxRetries() + ")";
        }
    }

    public static class TokenCacheConfig {
        private boolean enabled = true;
        private long ttl = 3600L;

        public boolean isEnabled() {
            return this.enabled;
        }

        public long getTtl() {
            return this.ttl;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setTtl(long ttl) {
            this.ttl = ttl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TokenCacheConfig)) {
                return false;
            }
            TokenCacheConfig other = (TokenCacheConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            return this.getTtl() == other.getTtl();
        }

        protected boolean canEqual(Object other) {
            return other instanceof TokenCacheConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            long $ttl = this.getTtl();
            result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
            return result;
        }

        public String toString() {
            return "DataverseConfig.TokenCacheConfig(enabled=" + this.isEnabled() + ", ttl=" + this.getTtl() + ")";
        }
    }
}

