/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.dataverse.metadata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.xuejike.query.dataverse.client.DataverseClient;
import com.github.xuejike.query.dataverse.client.ODataResponse;
import com.github.xuejike.query.dataverse.metadata.EntityMetadata;
import com.github.xuejike.query.dataverse.metadata.FieldMetadata;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataService {
    private static final Logger log = LoggerFactory.getLogger(MetadataService.class);
    private final DataverseClient client;
    private final Map<String, EntityMetadata> metadataCache;

    public MetadataService(DataverseClient client) {
        this.client = client;
        this.metadataCache = new ConcurrentHashMap<String, EntityMetadata>();
    }

    public EntityMetadata getEntityMetadata(String entityLogicalName) {
        return this.metadataCache.computeIfAbsent(entityLogicalName, this::fetchEntityMetadata);
    }

    public List<String> listAllEntities() {
        log.debug("Fetching list of all entities");
        String url = "EntityDefinitions?$select=LogicalName,DisplayName";
        ODataResponse response = this.client.get(url);
        ArrayList<String> entities = new ArrayList<String>();
        JSONArray value = response.getValue();
        if (value != null) {
            for (int i = 0; i < value.size(); ++i) {
                JSONObject item = value.getJSONObject(i);
                String logicalName = item.getString("LogicalName");
                if (logicalName == null) continue;
                entities.add(logicalName);
            }
        }
        log.debug("Found {} entities", (Object)entities.size());
        return entities;
    }

    public void clearCache() {
        this.metadataCache.clear();
        log.debug("Metadata cache cleared");
    }

    public void clearCache(String entityLogicalName) {
        this.metadataCache.remove(entityLogicalName);
        log.debug("Cleared metadata cache for entity: {}", (Object)entityLogicalName);
    }

    private EntityMetadata fetchEntityMetadata(String entityLogicalName) {
        log.debug("Fetching metadata for entity: {}", (Object)entityLogicalName);
        String url = String.format("EntityDefinitions(LogicalName='%s')?$expand=Attributes", entityLogicalName);
        ODataResponse response = this.client.get(url);
        JSONArray value = response.getValue();
        if (value == null || value.isEmpty()) {
            log.warn("No metadata found for entity: {}", (Object)entityLogicalName);
            return null;
        }
        JSONObject json = value.getJSONObject(0);
        EntityMetadata metadata = new EntityMetadata();
        metadata.setLogicalName(json.getString("LogicalName"));
        String displayName = this.extractDisplayName(json.getJSONObject("DisplayName"));
        metadata.setDisplayName(displayName);
        metadata.setPrimaryIdAttribute(json.getString("PrimaryIdAttribute"));
        metadata.setPrimaryNameAttribute(json.getString("PrimaryNameAttribute"));
        JSONArray attributes = json.getJSONArray("Attributes");
        if (attributes != null) {
            ArrayList<FieldMetadata> fields = new ArrayList<FieldMetadata>();
            for (int i = 0; i < attributes.size(); ++i) {
                JSONObject attr = attributes.getJSONObject(i);
                FieldMetadata field = this.parseFieldMetadata(attr);
                fields.add(field);
            }
            metadata.setFields(fields);
            log.debug("Parsed {} fields for entity {}", (Object)fields.size(), (Object)entityLogicalName);
        }
        return metadata;
    }

    private String extractDisplayName(JSONObject displayNameObj) {
        String label;
        if (displayNameObj == null) {
            return null;
        }
        JSONObject userLabel = displayNameObj.getJSONObject("UserLocalizedLabel");
        if (userLabel != null && (label = userLabel.getString("Label")) != null) {
            return label;
        }
        JSONArray labels = displayNameObj.getJSONArray("LocalizedLabels");
        if (labels != null && !labels.isEmpty()) {
            JSONObject firstLabel = labels.getJSONObject(0);
            return firstLabel.getString("Label");
        }
        return null;
    }

    private FieldMetadata parseFieldMetadata(JSONObject attr) {
        JSONArray targets;
        FieldMetadata field = new FieldMetadata();
        field.setLogicalName(attr.getString("LogicalName"));
        String displayName = this.extractDisplayName(attr.getJSONObject("DisplayName"));
        field.setDisplayName(displayName);
        String attributeType = attr.getString("AttributeType");
        field.setAttributeType(attributeType);
        Object requiredLevel = attr.get((Object)"RequiredLevel");
        boolean isRequired = false;
        if (requiredLevel != null) {
            if (requiredLevel instanceof JSONObject) {
                String value = ((JSONObject)requiredLevel).getString("Value");
                isRequired = "ApplicationRequired".equals(value) || "SystemRequired".equals(value);
            } else if (requiredLevel instanceof String) {
                isRequired = "ApplicationRequired".equals(requiredLevel) || "SystemRequired".equals(requiredLevel);
            }
        }
        field.setRequired(isRequired);
        Boolean isPrimaryId = attr.getBoolean("IsPrimaryId");
        field.setPrimaryKey(isPrimaryId != null && isPrimaryId != false);
        if ("String".equals(attributeType) || "Memo".equals(attributeType)) {
            Integer maxLength = attr.getInteger("MaxLength");
            field.setMaxLength(maxLength);
        } else if ("Decimal".equals(attributeType) || "Money".equals(attributeType)) {
            Integer precision = attr.getInteger("Precision");
            field.setPrecision(precision);
            if (precision == null) {
                precision = attr.getInteger("PrecisionSource");
                field.setPrecision(precision);
            }
            Double minValue = attr.getDouble("MinValue");
            Double maxValue = attr.getDouble("MaxValue");
            field.setMinValue(minValue);
            field.setMaxValue(maxValue);
        } else if ("Integer".equals(attributeType)) {
            Double minValue = attr.getDouble("MinValue");
            Double maxValue = attr.getDouble("MaxValue");
            field.setMinValue(minValue);
            field.setMaxValue(maxValue);
        } else if ("Double".equals(attributeType)) {
            Integer precision = attr.getInteger("Precision");
            field.setPrecision(precision);
            Double minValue = attr.getDouble("MinValue");
            Double maxValue = attr.getDouble("MaxValue");
            field.setMinValue(minValue);
            field.setMaxValue(maxValue);
        } else if (("Lookup".equals(attributeType) || "Customer".equals(attributeType) || "Owner".equals(attributeType)) && (targets = attr.getJSONArray("Targets")) != null && !targets.isEmpty()) {
            ArrayList<String> lookupTargets = new ArrayList<String>();
            for (int i = 0; i < targets.size(); ++i) {
                String target = targets.getString(i);
                if (target == null) continue;
                lookupTargets.add(target);
            }
            field.setLookupTargets(lookupTargets);
        }
        return field;
    }
}

