/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.mongo;

import cn.hutool.core.collection.CollUtil;
import com.github.xuejike.query.core.base.BaseWhereQuery;
import com.github.xuejike.query.core.criteria.DaoCriteria;
import com.github.xuejike.query.core.criteria.IPage;
import com.github.xuejike.query.core.criteria.InjectionBaseQuery;
import com.github.xuejike.query.core.po.FieldInfo;
import com.github.xuejike.query.mongo.MongoQueryBuilder;
import com.mongodb.client.result.DeleteResult;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class MongoDao<T>
implements DaoCriteria<T>,
InjectionBaseQuery {
    MongoTemplate mongoTemplate;
    private BaseWhereQuery baseWhereQuery;
    private Class<T> entityCls;

    public MongoDao(MongoTemplate mongoTemplate, Class<T> entityCls) {
        this.mongoTemplate = mongoTemplate;
        this.entityCls = entityCls;
    }

    private Query buildQuery() {
        List list;
        Field fields;
        Query builder = MongoQueryBuilder.builder(this.baseWhereQuery.buildQueryInfo());
        if (CollUtil.isNotEmpty((Collection)this.baseWhereQuery.getSelectList())) {
            fields = builder.fields();
            list = this.baseWhereQuery.getSelectList();
            for (FieldInfo info : list) {
                fields.include(MongoQueryBuilder.buildField(info));
            }
        }
        if (CollUtil.isNotEmpty((Collection)this.baseWhereQuery.getExcludeList())) {
            fields = builder.fields();
            list = this.baseWhereQuery.getExcludeList();
            for (FieldInfo info : list) {
                fields.exclude(MongoQueryBuilder.buildField(info));
            }
        }
        return builder;
    }

    public DaoCriteria<T> getDao() {
        return this;
    }

    public List<T> list() {
        if (this.baseWhereQuery.isEmpty()) {
            return this.mongoTemplate.findAll(this.entityCls);
        }
        return this.mongoTemplate.find(this.buildQuery(), this.entityCls);
    }

    public Long count() {
        return this.mongoTemplate.count(this.buildQuery(), this.entityCls);
    }

    public IPage<T> page(IPage<T> page) {
        Query query = this.buildQuery();
        if (page.isHaveTotal()) {
            long count = this.mongoTemplate.count(query, this.entityCls);
            page.setTotal(count);
        }
        query.skip((long)(page.getPageNo() * page.getPageSize()));
        query.limit(page.getPageSize());
        List ts = this.mongoTemplate.find(query, this.entityCls);
        page.setData(ts);
        return page;
    }

    public T findById(Serializable id) {
        return (T)this.mongoTemplate.findById((Object)id, this.entityCls);
    }

    public T updateById(T entity) {
        return (T)this.mongoTemplate.save(entity);
    }

    public Long updateFindAll() {
        Query query = this.buildQuery();
        Update update = new Update();
        return this.mongoTemplate.updateMulti(query, update, this.entityCls).getModifiedCount();
    }

    public boolean removeById(Serializable id) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"id").is((Object)id));
        DeleteResult remove = this.mongoTemplate.remove(query, this.entityCls);
        return remove.getDeletedCount() > 0L;
    }

    public long removeQueryAll() {
        Query query = this.buildQuery();
        return this.mongoTemplate.remove(query, this.entityCls).getDeletedCount();
    }

    public long executeUpdate(Object query, Object ... param) {
        if (query instanceof Document) {
            Document document = this.mongoTemplate.executeCommand((Document)query);
        } else if (query instanceof String) {
            Document document = this.mongoTemplate.executeCommand((String)query);
        }
        return 0L;
    }

    public List<?> execute(Object query, Object ... param) {
        if (query instanceof Document) {
            Document document = this.mongoTemplate.executeCommand((Document)query);
        } else if (query instanceof String) {
            Document document = this.mongoTemplate.executeCommand((String)query);
        }
        return null;
    }

    public void injectionBaseWhereQuery(BaseWhereQuery baseWhereQuery) {
        this.baseWhereQuery = baseWhereQuery;
    }
}

