/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.IOException;
import java.math.BigInteger;
import msgpack4z.ExtTypeHeader;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import org.msgpack.core.ExtensionTypeHeader;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ValueType;

public class MsgpackJavaUnpacker
implements MsgUnpacker {
    private final MessageUnpacker unpacker;

    public MsgpackJavaUnpacker(MessageUnpacker messageUnpacker) {
        this.unpacker = messageUnpacker;
    }

    public MsgpackJavaUnpacker(MessagePack.UnpackerConfig unpackerConfig, byte[] byArray) {
        this(unpackerConfig.newUnpacker(byArray));
    }

    public static MsgUnpacker defaultUnpacker(byte[] byArray) {
        return new MsgpackJavaUnpacker(new MessagePack.UnpackerConfig(), byArray);
    }

    public static MsgType toMsgType(ValueType valueType) {
        switch (valueType) {
            case NIL: {
                return MsgType.NIL;
            }
            case BOOLEAN: {
                return MsgType.BOOLEAN;
            }
            case INTEGER: {
                return MsgType.INTEGER;
            }
            case FLOAT: {
                return MsgType.FLOAT;
            }
            case STRING: {
                return MsgType.STRING;
            }
            case BINARY: {
                return MsgType.BINARY;
            }
            case ARRAY: {
                return MsgType.ARRAY;
            }
            case MAP: {
                return MsgType.MAP;
            }
            case EXTENSION: {
                return MsgType.EXTENSION;
            }
        }
        throw new RuntimeException("impossible");
    }

    public MsgType nextType() throws IOException {
        return MsgpackJavaUnpacker.toMsgType(this.unpacker.getNextFormat().getValueType());
    }

    public byte unpackByte() throws IOException {
        return this.unpacker.unpackByte();
    }

    public short unpackShort() throws IOException {
        return this.unpacker.unpackShort();
    }

    public int unpackInt() throws IOException {
        return this.unpacker.unpackInt();
    }

    public long unpackLong() throws IOException {
        return this.unpacker.unpackLong();
    }

    public BigInteger unpackBigInteger() throws IOException {
        return this.unpacker.unpackBigInteger();
    }

    public double unpackDouble() throws IOException {
        return this.unpacker.unpackDouble();
    }

    public float unpackFloat() throws IOException {
        return this.unpacker.unpackFloat();
    }

    public int unpackArrayHeader() throws IOException {
        return this.unpacker.unpackArrayHeader();
    }

    public void arrayEnd() throws IOException {
    }

    public void mapEnd() throws IOException {
    }

    public int unpackMapHeader() throws IOException {
        return this.unpacker.unpackMapHeader();
    }

    public boolean unpackBoolean() throws IOException {
        return this.unpacker.unpackBoolean();
    }

    public void unpackNil() throws IOException {
        this.unpacker.unpackNil();
    }

    public String unpackString() throws IOException {
        return this.unpacker.unpackString();
    }

    public byte[] unpackBinary() throws IOException {
        byte[] byArray = new byte[this.unpacker.unpackBinaryHeader()];
        this.unpacker.readPayload(byArray);
        return byArray;
    }

    public byte[] readPayload(int n) throws IOException {
        return this.unpacker.readPayload(n);
    }

    public void readPayload(byte[] byArray) throws IOException {
        this.unpacker.readPayload(byArray);
    }

    public ExtTypeHeader unpackExtTypeHeader() throws IOException {
        ExtensionTypeHeader extensionTypeHeader = this.unpacker.unpackExtensionTypeHeader();
        return new ExtTypeHeader(extensionTypeHeader.getType(), extensionTypeHeader.getLength());
    }

    public void close() throws IOException {
        this.unpacker.close();
    }
}

