/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import msgpack4z.MsgType;
import msgpack4z.MsgUnpacker;
import org.msgpack.unpacker.MessagePackUnpacker;

public class Msgpack06Unpacker
implements MsgUnpacker {
    private final MessagePackUnpacker self;
    private static final Method getHeadByteMethod;

    public Msgpack06Unpacker(MessagePackUnpacker messagePackUnpacker) {
        this.self = messagePackUnpacker;
    }

    private byte getHeadByte() {
        try {
            return (Byte)getHeadByteMethod.invoke((Object)this.self, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    public MsgType nextType() throws IOException {
        switch (this.self.getNextType()) {
            case NIL: {
                return MsgType.NIL;
            }
            case BOOLEAN: {
                return MsgType.BOOLEAN;
            }
            case INTEGER: {
                return MsgType.INTEGER;
            }
            case FLOAT: {
                return MsgType.FLOAT;
            }
            case ARRAY: {
                return MsgType.ARRAY;
            }
            case MAP: {
                return MsgType.MAP;
            }
            case RAW: {
                int n = this.getHeadByte() & 0xFF;
                if ((n & 0xE0) == 160) {
                    return MsgType.STRING;
                }
                switch (n) {
                    case 196: 
                    case 197: 
                    case 198: {
                        return MsgType.BINARY;
                    }
                    case 217: 
                    case 218: 
                    case 219: {
                        return MsgType.STRING;
                    }
                }
                throw new RuntimeException("impossible " + n);
            }
        }
        throw new RuntimeException("impossible");
    }

    public byte unpackByte() throws IOException {
        return this.self.readByte();
    }

    public short unpackShort() throws IOException {
        return this.self.readShort();
    }

    public int unpackInt() throws IOException {
        return this.self.readInt();
    }

    public long unpackLong() throws IOException {
        return this.self.readLong();
    }

    public BigInteger unpackBigInteger() throws IOException {
        return this.self.readBigInteger();
    }

    public double unpackDouble() throws IOException {
        return this.self.readDouble();
    }

    public float unpackFloat() throws IOException {
        return this.self.readFloat();
    }

    public int unpackArrayHeader() throws IOException {
        return this.self.readArrayBegin();
    }

    public void arrayEnd() throws IOException {
        this.self.readArrayEnd();
    }

    public void mapEnd() throws IOException {
        this.self.readMapEnd();
    }

    public int unpackMapHeader() throws IOException {
        return this.self.readMapBegin();
    }

    public boolean unpackBoolean() throws IOException {
        return this.self.readBoolean();
    }

    public void unpackNil() throws IOException {
        this.self.readNil();
    }

    public String unpackString() throws IOException {
        return this.self.readString();
    }

    public byte[] unpackBinary() throws IOException {
        return this.self.readByteArray();
    }

    public void close() throws IOException {
        this.self.close();
    }

    static {
        try {
            getHeadByteMethod = MessagePackUnpacker.class.getDeclaredMethod("getHeadByte", new Class[0]);
            getHeadByteMethod.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

