/*
 * Decompiled with CFR 0.152.
 */
package cdc.app;

import cdc.util.debug.Printable;
import cdc.util.lang.ImplementationException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class AppInfo
implements Printable {
    private static final List<String> MAIN_ARGS = new ArrayList<String>();
    private final Instant timestamp;
    private final List<String> mainArgs;
    private final List<String> vmArgs;
    private final Map<String, String> appProps;
    private final Map<String, String> env;
    private final Map<String, String> sysProps;
    private final List<String> stackTrace;

    private AppInfo(Instant timestamp, List<String> mainArgs, List<String> vmArgs, Map<String, String> appProps, Map<String, String> env, Map<String, String> sysProps, List<String> stacktrace) {
        RuntimeMXBean bean;
        this.timestamp = timestamp == null ? Instant.now() : timestamp;
        this.mainArgs = mainArgs == null ? new ArrayList<String>(MAIN_ARGS) : mainArgs;
        if (vmArgs == null) {
            this.vmArgs = new ArrayList<String>();
            bean = ManagementFactory.getRuntimeMXBean();
            this.vmArgs.addAll(bean.getInputArguments());
        } else {
            this.vmArgs = vmArgs;
        }
        this.appProps = appProps;
        this.env = env == null ? new HashMap<String, String>(System.getenv()) : env;
        if (sysProps == null) {
            bean = ManagementFactory.getRuntimeMXBean();
            this.sysProps = new HashMap<String, String>(bean.getSystemProperties());
        } else {
            this.sysProps = sysProps;
        }
        this.stackTrace = stacktrace;
    }

    public static void setMainArgs(String[] args) {
        MAIN_ARGS.clear();
        Collections.addAll(MAIN_ARGS, args);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public List<String> getMainArgs() {
        return this.mainArgs;
    }

    public Set<String> getEnvVarsNames() {
        return this.env.keySet();
    }

    public String getEnvVarValue(String name) {
        return this.env.get(name);
    }

    public Set<String> getSysPropsNames() {
        return this.sysProps.keySet();
    }

    public String getSysPropValue(String name) {
        return this.sysProps.get(name);
    }

    public Set<String> getAppPropsNames() {
        return this.appProps.keySet();
    }

    public String getAppPropValue(String name) {
        return this.appProps.get(name);
    }

    public List<String> getVMArgs() {
        return this.vmArgs;
    }

    public boolean hasStackTrace() {
        return !this.stackTrace.isEmpty();
    }

    public List<String> getStackTrace() {
        return this.stackTrace;
    }

    public void print(PrintStream out, int level) {
        this.indent(out, level);
        out.print("Timestamp: ");
        out.print(this.getTimestamp());
        out.println();
        this.indent(out, level);
        out.println("Main arguments");
        this.getMainArgs().stream().forEach(arg -> {
            this.indent(out, level + 1);
            out.print((String)arg);
            out.println();
        });
        this.indent(out, level);
        out.println("VM arguments");
        this.getVMArgs().stream().forEach(arg -> {
            this.indent(out, level + 1);
            out.print((String)arg);
            out.println();
        });
        this.indent(out, level);
        out.println("Application properties");
        this.getAppPropsNames().stream().sorted().forEach(key -> {
            this.indent(out, level + 1);
            out.print((String)key);
            out.print(": ");
            out.print(this.getAppPropValue((String)key));
            out.println();
        });
        this.indent(out, level);
        out.println("Environment variables");
        this.getEnvVarsNames().stream().sorted().forEach(key -> {
            this.indent(out, level + 1);
            out.print((String)key);
            out.print(": ");
            out.print(this.getEnvVarValue((String)key));
            out.println();
        });
        this.indent(out, level);
        out.println("System properties");
        this.getSysPropsNames().stream().sorted().forEach(key -> {
            this.indent(out, level + 1);
            out.print((String)key);
            out.print(": ");
            out.print(this.getSysPropValue((String)key));
            out.println();
        });
        if (this.hasStackTrace()) {
            this.indent(out, level);
            out.println("Stack trace");
            this.getStackTrace().stream().forEach(line -> {
                this.indent(out, level + 1);
                out.print((String)line);
                out.println();
            });
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Instant timestamp;
        private List<String> mainargs;
        private List<String> vmargs;
        private final Map<String, String> appProps = new HashMap<String, String>();
        private Map<String, String> env;
        private Map<String, String> sysprops;
        private final List<String> stacktrace = new ArrayList<String>();

        private Builder() {
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder mainArgs(List<String> args) {
            this.mainargs = new ArrayList<String>(args);
            return this;
        }

        public Builder vmArgs(List<String> args) {
            this.vmargs = new ArrayList<String>(args);
            return this;
        }

        public Builder appProp(String name, String value) {
            this.appProps.put(name, value);
            return this;
        }

        public Builder env(Map<String, String> env) {
            this.env = new HashMap<String, String>(env);
            return this;
        }

        public Builder sysProps(Map<String, String> sysprops) {
            this.sysprops = new HashMap<String, String>(sysprops);
            return this;
        }

        public Builder stacktrace(Throwable exception) {
            this.stacktrace.clear();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(buffer);){
                exception.printStackTrace(writer);
                writer.flush();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buffer.toByteArray())));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        this.stacktrace.add(line);
                    }
                }
                catch (IOException e) {
                    throw new ImplementationException("Failed to parse stacktrace", (Throwable)e);
                }
                Builder builder = this;
                return builder;
            }
        }

        public Builder stacktrace(List<String> stacktrace) {
            this.stacktrace.clear();
            this.stacktrace.addAll(stacktrace);
            return this;
        }

        public AppInfo build() {
            return new AppInfo(this.timestamp, this.mainargs, this.vmargs, this.appProps, this.env, this.sysprops, this.stacktrace);
        }
    }
}

