/*
 * Decompiled with CFR 0.152.
 */
package cdc.args;

import cdc.args.FormalArg;
import cdc.args.FormalArgs;
import cdc.util.lang.Checks;
import cdc.util.lang.Operators;

public final class Arg {
    private final String name;
    private final Object value;

    public Arg(String name, Object value) {
        FormalArg.checkName(name);
        this.name = name;
        this.value = value;
    }

    public <T> Arg(FormalArg<T> farg, T value) {
        Checks.isNotNull(farg, (String)"farg");
        Checks.isTrue((value != null || farg.isOptional() ? 1 : 0) != 0, (String)"null value is not compliant with {}", farg);
        this.name = farg.getName();
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue(Object def) {
        return this.value == null ? def : this.value;
    }

    public <T> T getValue(Class<T> cls) {
        return cls.cast(this.value);
    }

    public <T> T getValue(Class<T> cls, T def) {
        return this.value == null ? def : cls.cast(this.value);
    }

    public boolean isCompliantWith(FormalArg<?> farg) {
        Checks.isNotNull(farg, (String)"farg");
        return farg.matchesName(this.name) && (this.value == null ? farg.isOptional() : farg.getType().isInstance(this.value));
    }

    public boolean isCompliantWith(FormalArgs fargs) {
        Checks.isNotNull((Object)fargs, (String)"fargs");
        FormalArg<?> farg = fargs.getArg(this.name);
        return farg != null && farg.isCompliantWith(this.value);
    }

    public boolean isCompliantWith(Class<?> cls) {
        Checks.isNotNull(cls, (String)"cls");
        return this.value == null || cls.isInstance(this.value);
    }

    public int hashCode() {
        return this.name.hashCode() + Operators.hashCode((Object)this.value);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Arg)) {
            return false;
        }
        Arg other = (Arg)object;
        return this.name.equals(other.name) && Operators.equals((Object)this.value, (Object)other.value);
    }

    public String toString() {
        return "[" + this.name + "=" + this.value + "]";
    }
}

