/*
 * Decompiled with CFR 0.152.
 */
package cdc.validation.io;

import cdc.io.data.Element;
import cdc.io.data.util.AbstractResourceLoader;
import cdc.util.lang.FailureReaction;
import cdc.validation.Validator;
import cdc.validation.ValidatorImpl;
import cdc.validation.Validators;
import cdc.validation.checkers.Checker;
import cdc.validation.io.CheckersIo;

public final class ValidatorsIo {
    public static final String ERROR = "error";
    public static final String NAME = "name";
    public static final String VALIDATOR = "validator";
    public static final String VALIDATORS = "validators";
    public static final String WARNING = "warning";

    private ValidatorsIo() {
    }

    public static class DataLoader
    extends AbstractResourceLoader<Void> {
        private final CheckersIo.DataLoader checkersLoader;

        public DataLoader(FailureReaction reaction) {
            super(reaction);
            this.checkersLoader = new CheckersIo.DataLoader(reaction);
        }

        protected Void loadRoot(Element root) {
            if (ValidatorsIo.VALIDATORS.equals(root.getName())) {
                this.loadAndRegisterNamedValidators(root);
            } else {
                this.unexpectedElement(root, new String[]{ValidatorsIo.VALIDATORS});
            }
            return null;
        }

        private void loadAndRegisterNamedValidators(Element element) {
            for (Element child : element.getElements()) {
                if (ValidatorsIo.VALIDATOR.equals(child.getName())) {
                    this.loadAndRegisterNamedValidator(child);
                    continue;
                }
                this.unexpectedElement(child, new String[]{ValidatorsIo.VALIDATOR});
            }
        }

        private void loadAndRegisterNamedValidator(Element element) {
            String name = element.getAttributeValue(ValidatorsIo.NAME, null, this.getReaction());
            Validator<?> validator = this.loadValidator(element);
            if (validator != null) {
                if (Validators.hasValidator((String)name)) {
                    this.onError("A validator named '" + name + "' is already registered");
                } else {
                    Validators.register(validator, (String)name);
                }
            }
        }

        public Validator<?> loadValidator(Element element) {
            Checker<?> warning;
            Checker<?> error = this.loadChecker(element, ValidatorsIo.ERROR);
            ValidatorImpl validator = ValidatorImpl.createUnchecked(error, warning = this.loadChecker(element, ValidatorsIo.WARNING));
            if (validator == null) {
                return (Validator)this.onError("Failed to create validator", null);
            }
            return validator;
        }

        private Checker<?> loadChecker(Element parent, String name) {
            if (parent.hasChildren(Element.class, Element.named((String)name))) {
                Element wrapper = (Element)parent.getChildAt(Element.class, Element.named((String)name), 0);
                return this.checkersLoader.loadChildChecker(wrapper);
            }
            return null;
        }
    }
}

