/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.helper;

import com.googlecode.androidannotations.helper.AndroidManifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifestFinder {
    private static final String ANDROID_MANIFEST_FILE_OPTION = "androidManifestFile";
    private static final int MAX_PARENTS_FROM_SOURCE_FOLDER = 10;
    private ProcessingEnvironment processingEnv;

    public AndroidManifestFinder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public AndroidManifest extractAndroidManifest() {
        try {
            return this.extractAndroidManifestThrowing();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private AndroidManifest extractAndroidManifestThrowing() throws Exception {
        File androidManifestFile = this.findManifestFileThrowing();
        String projectDirectory = androidManifestFile.getParent();
        File projectProperties = new File(projectDirectory, "project.properties");
        boolean libraryProject = false;
        if (projectProperties.exists()) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(projectProperties));
            if (properties.containsKey("android.library")) {
                String androidLibraryProperty = properties.getProperty("android.library");
                libraryProject = androidLibraryProperty.equals("true");
                Messager messager = this.processingEnv.getMessager();
                messager.printMessage(Diagnostic.Kind.NOTE, "Found android.library property in project.properties, value: " + libraryProject);
            }
        }
        return this.parseThrowing(androidManifestFile, libraryProject);
    }

    private File findManifestFileThrowing() throws Exception {
        if (this.processingEnv.getOptions().containsKey(ANDROID_MANIFEST_FILE_OPTION)) {
            return this.findManifestInSpecifiedPath();
        }
        return this.findManifestInParentsDirectories();
    }

    private File findManifestInSpecifiedPath() {
        String path = this.processingEnv.getOptions().get(ANDROID_MANIFEST_FILE_OPTION);
        File androidManifestFile = new File(path);
        Messager messager = this.processingEnv.getMessager();
        if (!androidManifestFile.exists()) {
            throw new IllegalStateException("Could not find the AndroidManifest.xml file in specified path : " + path);
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "AndroidManifest.xml file found: " + androidManifestFile.toString());
        return androidManifestFile;
    }

    private File findManifestInParentsDirectories() throws IOException, URISyntaxException {
        Filer filer = this.processingEnv.getFiler();
        JavaFileObject dummySourceFile = filer.createSourceFile("dummy" + System.currentTimeMillis(), new Element[0]);
        String dummySourceFilePath = dummySourceFile.toUri().toString();
        if (dummySourceFilePath.startsWith("file:")) {
            if (!dummySourceFilePath.startsWith("file://")) {
                dummySourceFilePath = "file://" + dummySourceFilePath.substring("file:".length());
            }
        } else {
            dummySourceFilePath = "file://" + dummySourceFilePath;
        }
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Dummy source file: " + dummySourceFilePath);
        URI cleanURI = new URI(dummySourceFilePath);
        File dummyFile = new File(cleanURI);
        File sourcesGenerationFolder = dummyFile.getParentFile();
        File projectRoot = sourcesGenerationFolder.getParentFile();
        File androidManifestFile = new File(projectRoot, "AndroidManifest.xml");
        for (int i = 0; i < 10 && !androidManifestFile.exists() && projectRoot.getParentFile() != null; ++i) {
            projectRoot = projectRoot.getParentFile();
            androidManifestFile = new File(projectRoot, "AndroidManifest.xml");
        }
        if (!androidManifestFile.exists()) {
            throw new IllegalStateException("Could not find the AndroidManifest.xml file, going up from path [" + sourcesGenerationFolder.getAbsolutePath() + "] found using dummy file [" + dummySourceFilePath + "] (max atempts: " + 10 + ")");
        }
        messager.printMessage(Diagnostic.Kind.NOTE, "AndroidManifest.xml file found: " + androidManifestFile.toString());
        return androidManifestFile;
    }

    private AndroidManifest parseThrowing(File androidManifestFile, boolean libraryProject) throws Exception {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(androidManifestFile);
        org.w3c.dom.Element documentElement = doc.getDocumentElement();
        documentElement.normalize();
        String applicationPackage = documentElement.getAttribute("package");
        if (libraryProject) {
            return AndroidManifest.createLibraryManifest(applicationPackage);
        }
        NodeList applicationNodes = documentElement.getElementsByTagName("application");
        String applicationQualifiedName = null;
        if (applicationNodes.getLength() > 0) {
            Node applicationNode = applicationNodes.item(0);
            Node nameAttribute = applicationNode.getAttributes().getNamedItem("android:name");
            String qualifiedName = this.manifestNameToValidQualifiedName(applicationPackage, nameAttribute);
            if (qualifiedName != null) {
                applicationQualifiedName = qualifiedName;
            } else {
                Messager messager = this.processingEnv.getMessager();
                if (nameAttribute != null) {
                    messager.printMessage(Diagnostic.Kind.NOTE, String.format("The class application declared in the AndroidManifest.xml cannot be found in the compile path: [%s]", nameAttribute.getNodeValue()));
                }
            }
        }
        NodeList activityNodes = documentElement.getElementsByTagName("activity");
        List<String> activityQualifiedNames = this.extractComponentNames(applicationPackage, activityNodes);
        NodeList serviceNodes = documentElement.getElementsByTagName("service");
        List<String> serviceQualifiedNames = this.extractComponentNames(applicationPackage, serviceNodes);
        NodeList receiverNodes = documentElement.getElementsByTagName("receiver");
        List<String> receiverQualifiedNames = this.extractComponentNames(applicationPackage, receiverNodes);
        NodeList providerNodes = documentElement.getElementsByTagName("provider");
        List<String> providerQualifiedNames = this.extractComponentNames(applicationPackage, providerNodes);
        ArrayList<String> componentQualifiedNames = new ArrayList<String>();
        componentQualifiedNames.addAll(activityQualifiedNames);
        componentQualifiedNames.addAll(serviceQualifiedNames);
        componentQualifiedNames.addAll(receiverQualifiedNames);
        componentQualifiedNames.addAll(providerQualifiedNames);
        return AndroidManifest.createManifest(applicationPackage, applicationQualifiedName, componentQualifiedNames);
    }

    private List<String> extractComponentNames(String applicationPackage, NodeList componentNodes) {
        ArrayList<String> componentQualifiedNames = new ArrayList<String>();
        for (int i = 0; i < componentNodes.getLength(); ++i) {
            Node activityNode = componentNodes.item(i);
            Node nameAttribute = activityNode.getAttributes().getNamedItem("android:name");
            String qualifiedName = this.manifestNameToValidQualifiedName(applicationPackage, nameAttribute);
            if (qualifiedName != null) {
                componentQualifiedNames.add(qualifiedName);
                continue;
            }
            Messager messager = this.processingEnv.getMessager();
            if (nameAttribute != null) {
                messager.printMessage(Diagnostic.Kind.NOTE, String.format("A class activity declared in the AndroidManifest.xml cannot be found in the compile path: [%s]", nameAttribute.getNodeValue()));
                continue;
            }
            messager.printMessage(Diagnostic.Kind.NOTE, String.format("The %d activity node in the AndroidManifest.xml has no android:name attribute", i));
        }
        return componentQualifiedNames;
    }

    private String manifestNameToValidQualifiedName(String applicationPackage, Node nameAttribute) {
        if (nameAttribute != null) {
            String activityName = nameAttribute.getNodeValue();
            if (activityName.startsWith(applicationPackage)) {
                return this.returnClassIfExistsOrNull(activityName);
            }
            if (activityName.startsWith(".")) {
                return this.returnClassIfExistsOrNull(applicationPackage + activityName);
            }
            if (this.classOrModelClassExists(activityName)) {
                return activityName;
            }
            return this.returnClassIfExistsOrNull(applicationPackage + "." + activityName);
        }
        return null;
    }

    private boolean classOrModelClassExists(String className) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        if (className.endsWith("_")) {
            className = className.substring(0, className.length() - 1);
        }
        return elementUtils.getTypeElement(className) != null;
    }

    private String returnClassIfExistsOrNull(String className) {
        if (this.classOrModelClassExists(className)) {
            return className;
        }
        return null;
    }
}

