/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.model;

import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JFieldRef;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.type.TypeMirror;

public class AndroidSystemServices {
    private Map<String, String> registeredServices = new HashMap<String, String>();

    public AndroidSystemServices() {
        this.registeredServices.put("android.view.accessibility.AccessibilityManager", "android.content.Context.ACCESSIBILITY_SERVICE");
        this.registeredServices.put("android.accounts.AccountManager", "android.content.Context.ACCOUNT_SERVICE");
        this.registeredServices.put("android.app.ActivityManager", "android.content.Context.ACTIVITY_SERVICE");
        this.registeredServices.put("android.app.AlarmManager", "android.content.Context.ALARM_SERVICE");
        this.registeredServices.put("android.media.AudioManager", "android.content.Context.AUDIO_SERVICE");
        this.registeredServices.put("android.text.ClipboardManager", "android.content.Context.CLIPBOARD_SERVICE");
        this.registeredServices.put("android.net.ConnectivityManager", "android.content.Context.CONNECTIVITY_SERVICE");
        this.registeredServices.put("android.location.CountryDetector", "android.content.Context.COUNTRY_DETECTOR");
        this.registeredServices.put("android.app.admin.DevicePolicyManager", "android.content.Context.DEVICE_POLICY_SERVICE");
        this.registeredServices.put("android.app.DownloadManager", "android.content.Context.DOWNLOAD_SERVICE");
        this.registeredServices.put("android.os.DropBoxManager", "android.content.Context.DROPBOX_SERVICE");
        this.registeredServices.put("android.view.inputmethod.InputMethodManager", "android.content.Context.INPUT_METHOD_SERVICE");
        this.registeredServices.put("android.app.KeyguardManager", "android.content.Context.KEYGUARD_SERVICE");
        this.registeredServices.put("android.view.LayoutInflater", "android.content.Context.LAYOUT_INFLATER_SERVICE");
        this.registeredServices.put("android.location.LocationManager", "android.content.Context.LOCATION_SERVICE");
        this.registeredServices.put("android.net.NetworkManagementService", "android.content.Context.NETWORKMANAGEMENT_SERVICE");
        this.registeredServices.put("android.net.NetworkPolicyManager", "android.content.Context.NETWORK_POLICY_SERVICE");
        this.registeredServices.put("android.nfc.NfcManager", "android.content.Context.NFC_SERVICE");
        this.registeredServices.put("android.app.NotificationManager", "android.content.Context.NOTIFICATION_SERVICE");
        this.registeredServices.put("android.os.PowerManager", "android.content.Context.POWER_SERVICE");
        this.registeredServices.put("android.app.SearchManager", "android.content.Context.SEARCH_SERVICE");
        this.registeredServices.put("android.appwidget.AppWidgetManager", "android.content.Context.APPWIDGET_SERVICE");
        this.registeredServices.put("android.hardware.SensorManager", "android.content.Context.SENSOR_SERVICE");
        this.registeredServices.put("android.app.StatusBarManager", "android.content.Context.STATUS_BAR_SERVICE");
        this.registeredServices.put("android.os.storage.StorageManager", "android.content.Context.STORAGE_SERVICE");
        this.registeredServices.put("android.telephony.TelephonyManager", "android.content.Context.TELEPHONY_SERVICE");
        this.registeredServices.put("android.view.textservice.TextServicesManager", "android.content.Context.TEXT_SERVICES_MANAGER_SERVICE");
        this.registeredServices.put("android.net.ThrottleManager", "android.content.Context.THROTTLE_SERVICE");
        this.registeredServices.put("android.app.UiModeManager", "android.content.Context.UI_MODE_SERVICE");
        this.registeredServices.put("android.hardware.usb.UsbManager", "android.content.Context.USB_SERVICE");
        this.registeredServices.put("android.os.Vibrator", "android.content.Context.VIBRATOR_SERVICE");
        this.registeredServices.put("android.app.WallpaperManager", "android.content.Context.WALLPAPER_SERVICE");
        this.registeredServices.put("android.net.wifi.WifiManager", "android.content.Context.WIFI_SERVICE");
        this.registeredServices.put("android.net.wifi.p2p.WifiP2pManager", "android.content.Context.WIFI_P2P_SERVICE");
        this.registeredServices.put("android.view.WindowManager", "android.content.Context.WINDOW_SERVICE");
    }

    public boolean contains(TypeMirror serviceType) {
        return this.registeredServices.containsKey(((Object)serviceType).toString());
    }

    public String getServiceConstant(TypeMirror serviceType) {
        return this.registeredServices.get(((Object)serviceType).toString());
    }

    public JFieldRef getServiceConstant(TypeMirror serviceType, EBeanHolder holder) {
        return this.extractIdStaticRef(holder, this.registeredServices.get(((Object)serviceType).toString()));
    }

    private JFieldRef extractIdStaticRef(EBeanHolder holder, String staticFieldQualifiedName) {
        if (staticFieldQualifiedName != null) {
            int fieldSuffix = staticFieldQualifiedName.lastIndexOf(46);
            String fieldName = staticFieldQualifiedName.substring(fieldSuffix + 1);
            String className = staticFieldQualifiedName.substring(0, fieldSuffix);
            return holder.refClass(className).staticRef(fieldName);
        }
        return null;
    }
}

