/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.EView;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.processing.GeneratingElementProcessor;
import com.sun.codemodel.ClassType;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.lang.annotation.Annotation;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class EViewProcessor
implements GeneratingElementProcessor {
    private static final String ALREADY_INFLATED_COMMENT = "The mAlreadyInflated_ hack is needed because of an Android bug\nwhich leads to infinite calls of onFinishInflate()\nwhen inflating a layout with a parent and using\nthe <merge /> tag.";
    private static final String SUPPRESS_WARNING_COMMENT = "We use @SuppressWarning here because our java code\ngenerator doesn't know that there is no need\nto import OnXXXListeners from View as we already\nare in a View.";
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();

    @Override
    public Class<? extends Annotation> getTarget() {
        return EView.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeansHolder eBeansHolder) throws Exception {
        EBeansHolder.Classes classes = eBeansHolder.classes();
        TypeElement typeElement = (TypeElement)element;
        String eBeanQualifiedName = typeElement.getQualifiedName().toString();
        String generatedBeanQualifiedName = eBeanQualifiedName + "_";
        int modifiers = element.getModifiers().contains((Object)Modifier.ABSTRACT) ? 33 : 9;
        JDefinedClass generatedClass = codeModel._class(modifiers, generatedBeanQualifiedName, ClassType.CLASS);
        EBeanHolder holder = eBeansHolder.create(element, this.getTarget(), generatedClass);
        JClass eBeanClass = codeModel.directClass(eBeanQualifiedName);
        holder.generatedClass._extends(eBeanClass);
        holder.generatedClass.annotate(SuppressWarnings.class).param("value", "unused");
        holder.generatedClass.javadoc().append(SUPPRESS_WARNING_COMMENT);
        holder.contextRef = holder.generatedClass.field(4, classes.CONTEXT, "context_");
        holder.init = holder.generatedClass.method(4, codeModel.VOID, "init_");
        holder.init.body().assign((JFieldVar)holder.contextRef, JExpr.invoke("getContext"));
        holder.afterSetContentView = holder.generatedClass.method(4, codeModel.VOID, "afterSetContentView_");
        JFieldVar mAlreadyInflated_ = holder.generatedClass.field(4, JType.parse(codeModel, "boolean"), "mAlreadyInflated_", JExpr.FALSE);
        JMethod onFinishInflate = holder.generatedClass.method(1, codeModel.VOID, "onFinishInflate");
        onFinishInflate.annotate(Override.class);
        onFinishInflate.javadoc().append(ALREADY_INFLATED_COMMENT);
        JBlock ifNotInflated = onFinishInflate.body()._if(JExpr.ref("mAlreadyInflated_").not())._then();
        ifNotInflated.assign(mAlreadyInflated_, JExpr.TRUE);
        ifNotInflated.invoke(holder.afterSetContentView);
        onFinishInflate.body().invoke(JExpr._super(), "onFinishInflate");
        this.codeModelHelper.copyConstructorsAndAddStaticEViewBuilders(element, codeModel, eBeanClass, holder, onFinishInflate);
        APTCodeModelHelper helper = new APTCodeModelHelper();
        holder.initIfActivityBody = helper.ifContextInstanceOfActivity(holder, holder.init.body());
        holder.initActivityRef = helper.castContextToActivity(holder, holder.initIfActivityBody);
    }
}

