/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.OrmLiteDao;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class OrmLiteDaoValidator
implements ElementValidator {
    private IdValidatorHelper validatorHelper;
    private IdAnnotationHelper annotationHelper;

    public OrmLiteDaoValidator(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(this.annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return OrmLiteDao.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.hasOrmLiteJars(element, valid);
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.extendsOrmLiteDaoWithValidModelParameter(element, valid);
        this.validatorHelper.hasASqlLiteOpenHelperParameterizedType(element, valid);
        return valid.isValid();
    }
}

