/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.annotationprocessor;

import com.googlecode.androidannotations.annotationprocessor.SupportedAnnotationClasses;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.tools.Diagnostic;

public abstract class AnnotatedAbstractProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Class<? extends Annotation>[] annotationClassesArray = this.readSupportedAnnotationClasses();
        if (annotationClassesArray == null) {
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No " + SupportedAnnotationClasses.class.getSimpleName() + " annotation " + "found on " + this.getClass().getName() + ", returning parent method result.");
            }
            return super.getSupportedAnnotationTypes();
        }
        return AnnotatedAbstractProcessor.arrayToSet(annotationClassesArray);
    }

    private Class<? extends Annotation>[] readSupportedAnnotationClasses() {
        SupportedAnnotationClasses sac = this.getClass().getAnnotation(SupportedAnnotationClasses.class);
        if (sac != null) {
            return sac.value();
        }
        return null;
    }

    public Set<Class<? extends Annotation>> getSupportedAnnotationClasses() {
        Class<? extends Annotation>[] annotationClassesArray = this.readSupportedAnnotationClasses();
        if (annotationClassesArray == null) {
            return Collections.emptySet();
        }
        HashSet<Class<? extends Annotation>> set = new HashSet<Class<? extends Annotation>>(annotationClassesArray.length);
        for (Class<? extends Annotation> c : annotationClassesArray) {
            set.add(c);
        }
        return Collections.unmodifiableSet(set);
    }

    private static Set<String> arrayToSet(Class<? extends Annotation>[] array) {
        HashSet<String> set = new HashSet<String>(array.length);
        for (Class<? extends Annotation> c : array) {
            set.add(c.getName());
        }
        return Collections.unmodifiableSet(set);
    }
}

