/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.EFragment;
import com.googlecode.androidannotations.annotations.OptionsMenu;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.SherlockHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class OptionsMenuProcessor
implements DecoratingElementProcessor {
    private final SherlockHelper sherlockHelper;
    private IdAnnotationHelper annotationHelper;

    public OptionsMenuProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.sherlockHelper = new SherlockHelper(this.annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return OptionsMenu.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String getMenuInflaterMethodName;
        JClass menuInflaterClass;
        JClass menuClass;
        boolean isFragment;
        EBeansHolder.Classes classes = holder.classes();
        boolean bl = isFragment = holder.eBeanAnnotation == EFragment.class;
        if (this.sherlockHelper.usesSherlock(holder)) {
            menuClass = classes.SHERLOCK_MENU;
            menuInflaterClass = classes.SHERLOCK_MENU_INFLATER;
            getMenuInflaterMethodName = "getSupportMenuInflater";
        } else {
            menuClass = classes.MENU;
            menuInflaterClass = classes.MENU_INFLATER;
            getMenuInflaterMethodName = "getMenuInflater";
        }
        List<JFieldRef> fieldRefs = this.annotationHelper.extractAnnotationFieldRefs(holder, element, IRClass.Res.MENU, false);
        JPrimitiveType returnType = isFragment ? codeModel.VOID : codeModel.BOOLEAN;
        JMethod method = holder.generatedClass.method(1, returnType, "onCreateOptionsMenu");
        method.annotate(Override.class);
        JVar menuParam = method.param(menuClass, "menu");
        JBlock body = method.body();
        JVar menuInflater = isFragment ? method.param(menuInflaterClass, "inflater") : body.decl(menuInflaterClass, "menuInflater", JExpr.invoke(getMenuInflaterMethodName));
        for (JFieldRef optionsMenuRefId : fieldRefs) {
            body.invoke((JExpression)menuInflater, "inflate").arg(optionsMenuRefId).arg(menuParam);
        }
        JInvocation superCall = JExpr.invoke(JExpr._super(), method).arg(menuParam);
        if (isFragment) {
            superCall.arg(menuInflater);
            body.add(superCall);
        } else {
            body._return(superCall);
        }
        if (isFragment) {
            holder.init.body().invoke("setHasOptionsMenu").arg(JExpr.TRUE);
        }
    }
}

