/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.ViewById;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JFieldRef;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;

public class ViewByIdProcessor
implements DecoratingElementProcessor {
    private final IdAnnotationHelper annotationHelper;

    public ViewByIdProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return ViewById.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String fieldName = element.getSimpleName().toString();
        TypeMirror uiFieldTypeMirror = element.asType();
        String typeQualifiedName = ((Object)uiFieldTypeMirror).toString();
        JFieldRef idRef = this.annotationHelper.extractOneAnnotationFieldRef(holder, element, IRClass.Res.ID, true);
        JBlock methodBody = holder.afterSetContentView.body();
        methodBody.assign(JExpr.ref(fieldName), JExpr.cast(holder.refClass(typeQualifiedName), JExpr.invoke("findViewById").arg(idRef)));
    }
}

