package com.googlecode.googleplus.model.person;

import java.util.List;

import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.springframework.http.HttpHeaders;

@JsonIgnoreProperties(ignoreUnknown = true)
public class Person {

    private String relationshipStatus;
    private List<PersonOrganizations> organizations;
    private String kind;
    private String displayName;
    private PersonName name;
    private String url;
    private String gender;
    private String aboutMe;
    private String tagline;
    private List<PersonUrls> urls;
    private List<PersonPlacesLived> placesLived;
    private List<PersonEmails> emails;
    private String id;
    private String nickname;
    private String birthday;
    private PersonImage image;
    private boolean hasApp;
    private List<String> languagesSpoken;
    private String currentLocation;
    private HttpHeaders responseHeaders;

    public String getRelationshipStatus() {
        return relationshipStatus;
    }

    public void setRelationshipStatus(String relationshipStatus) {
        this.relationshipStatus = relationshipStatus;
    }

    public List<PersonOrganizations> getOrganizations() {
        return organizations;
    }

    public void setOrganizations(List<PersonOrganizations> organizations) {
        this.organizations = organizations;
    }

    public String getKind() {
        return kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public PersonName getName() {
        return name;
    }

    public void setName(PersonName name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getAboutMe() {
        return aboutMe;
    }

    public void setAboutMe(String aboutMe) {
        this.aboutMe = aboutMe;
    }

    public String getTagline() {
        return tagline;
    }

    public void setTagline(String tagline) {
        this.tagline = tagline;
    }

    public List<PersonUrls> getUrls() {
        return urls;
    }

    public void setUrls(List<PersonUrls> urls) {
        this.urls = urls;
    }

    public List<PersonPlacesLived> getPlacesLived() {
        return placesLived;
    }

    public void setPlacesLived(List<PersonPlacesLived> placesLived) {
        this.placesLived = placesLived;
    }

    public List<PersonEmails> getEmails() {
        return emails;
    }

    public void setEmails(List<PersonEmails> emails) {
        this.emails = emails;
    }

    public boolean hasGoogleAccountEmail() {
        return getGoogleAccountEmail() != null;
    }

    public String getGoogleAccountEmail() {
        if (emails == null) {
            return null;
        }
        for (PersonEmails email : getEmails()) {
            if (email != null && email.isGoogle()) {
                return email.getValue();
            }
        }
        return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getBirthday() {
        return birthday;
    }

    public void setBirthday(String birthday) {
        this.birthday = birthday;
    }

    public PersonImage getImage() {
        return image;
    }

    public void setImage(PersonImage image) {
        this.image = image;
    }

    public boolean isHasApp() {
        return hasApp;
    }

    public void setHasApp(boolean hasApp) {
        this.hasApp = hasApp;
    }

    public List<String> getLanguagesSpoken() {
        return languagesSpoken;
    }

    public void setLanguagesSpoken(List<String> languagesSpoken) {
        this.languagesSpoken = languagesSpoken;
    }

    public String getCurrentLocation() {
        return currentLocation;
    }

    public void setCurrentLocation(String currentLocation) {
        this.currentLocation = currentLocation;
    }

    public HttpHeaders getResponseHeaders() {
        return responseHeaders;
    }

    public void setResponseHeaders(HttpHeaders responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

}
