/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus.impl;

import com.googlecode.googleplus.MomentsOperations;
import com.googlecode.googleplus.Paging;
import com.googlecode.googleplus.PlusUtils;
import com.googlecode.googleplus.model.moments.Moment;
import com.googlecode.googleplus.model.moments.MomentCollection;
import com.googlecode.googleplus.model.moments.MomentFeed;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.web.client.RestTemplate;

public class MomentsOperationsImpl
implements MomentsOperations {
    private static final String INSERT_URL = "https://www.googleapis.com/plus/v1people/{userId}/moments/{collection}";
    private static final String LIST_URL = "https://www.googleapis.com/plus/v1people/{userId}/moments/{collection}";
    private static final String DELETE_URL = "moments/{id}";
    private RestTemplate restTemplate;

    public MomentsOperationsImpl(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void insert(Moment moment, MomentCollection collection) {
        this.restTemplate.postForObject("https://www.googleapis.com/plus/v1people/{userId}/moments/{collection}", (Object)moment, Map.class, new Object[]{"me", collection.getCollectionName()});
    }

    public MomentFeed list(String userId, MomentCollection collection, String targetUrlFilter, String typeFilter) {
        return this.list(userId, collection, targetUrlFilter, typeFilter, null);
    }

    public MomentFeed list(String userId, MomentCollection collection, String targetUrlFilter, String typeFilter, Paging paging) {
        Assert.notNull((Object)userId);
        Assert.notNull((Object)((Object)collection));
        Map<String, String> params = PlusUtils.createParamMap(paging);
        if (targetUrlFilter != null) {
            params.put("targetUrl", targetUrlFilter);
        }
        if (typeFilter != null) {
            params.put("typeFilter", typeFilter);
        }
        return (MomentFeed)this.restTemplate.getForObject(PlusUtils.addParameters("https://www.googleapis.com/plus/v1people/{userId}/moments/{collection}", params), MomentFeed.class, new Object[]{userId, collection.getCollectionName()});
    }

    public void remove(String momentId) {
        Assert.notNull((Object)momentId);
        this.restTemplate.delete(DELETE_URL, new Object[]{momentId});
    }
}

