package com.googlecode.java_cl_parser;

import org.apache.commons.cli.Option;

@java.lang.annotation.Target({java.lang.annotation.ElementType.METHOD})
@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)
public @interface CLIOption
{
	enum value_type
	{
		required,
		optional,
		not_allowed
	}

	int UNLIMITED_VALUES = Option.UNLIMITED_VALUES;

	String name();

	/**
	 * Default is the same as the name
	 *
	 * @return
	 */
	String longName() default "\0";

	String description() default "No description provided";

	/**
	 * Default is false
	 *
	 * @return
	 */
	boolean required() default false;

	/**
	 * default is value_type.optional
	 *
	 * @return
	 */
	value_type valueType() default value_type.optional;

	/**
	 * Default is 1
	 *
	 * @return
	 */
	int valueCardinality() default 1;

	/**
	 * Defines char used to separate list entries in a value list.  Default is a comma.
	 *
	 * @return
	 */
	String valueSeparator() default ",";

	/**
	 * Default is an empty string
	 *
	 * @return
	 */
	String defaultValue() default "\0";

	/**
	 * Defines a list of values that represent the valid argument values.
	 * A single string with a null character represents no enumerated values.
	 * @return
	 */
	String [] enumeratedValues() default "\0";
}