package com.googlecode.java_cl_parser;

import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.List;

//	${optline.shortName} |${optline.longName} |${optline.dataType} |${optline.defaultValue} |${optline.description}
public class OptionLine {
	private String shortName;
	private String longName;
	private String dataType;
	private String defaultValue;
	private final List<String> descriptionLines = new ArrayList<String>();

	public List<String> getDescriptionLines()
	{
		return descriptionLines;
	}

	public String getShortName()
	{
		return shortName;
	}

	public void setShortName(String shortName)
	{
		this.shortName = padAndAbbreviate(shortName, 10);
	}

	public String getLongName()
	{
		return longName;
	}

	public void setLongName(String longName)
	{
		this.longName = padAndAbbreviate(longName, 15);
	}

	public String getDataType()
	{
		return dataType;
	}

	public void setDataType(String dataType)
	{
		this.dataType = padAndAbbreviate(dataType, 9);
	}

	public String getDefaultValue()
	{
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue)
	{
		this.defaultValue = padAndAbbreviate(defaultValue, 15);
	}

	public String padAndAbbreviate(String defaultValue, int length)
	{
		return StringUtils.rightPad(StringUtils.abbreviate(defaultValue, length), length);
	}
}