package com.googlecode.java_cl_parser;

import org.apache.commons.io.IOUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UsageException extends Exception {
	private final List<CommonsCLILauncher.Data> availableOptions;
	private Object cliEntry;

	public UsageException(Object entry, List<CommonsCLILauncher.Data> options)
	{
		cliEntry = entry;
		availableOptions = options;
	}

	public UsageException(Object entry, List<CommonsCLILauncher.Data> options, String message)
	{
		super(message);

		cliEntry = entry;
		availableOptions = options;
	}

	public UsageException(Object entry, List<CommonsCLILauncher.Data> options, String message, Throwable cause)
	{
		super(message, cause);

		cliEntry = entry;
		availableOptions = options;
	}

	public UsageException(Object entry, List<CommonsCLILauncher.Data> options, Throwable cause)
	{
		super(cause);

		cliEntry = entry;
		availableOptions = options;
	}

	public List<CommonsCLILauncher.Data> getAvailableOptions()
	{
		return availableOptions;
	}

	public String getFormattedUsageStatement()
	{
		CLIEntry entry = cliEntry.getClass().getAnnotation(CLIEntry.class);

		Map<String, Object> map = new HashMap<String, Object>();

		String value = entry.nickName();
		if (value.equals("\0"))
		{
			value = cliEntry.getClass().getSimpleName();
		}
		map.put("nickName", value);

		value = entry.description();
		if (!value.equals("\0"))
		{
			map.put("description", StringUtil.wrapTextToList(value, 80));
		}

		value = entry.contact();
		if (!value.equals("\0"))
		{
			map.put("contact", value);
		}

		value = entry.versionControl();
		if (!value.equals("\0"))
		{
			map.put("scm", value);
		}

		value = entry.url();
		if (!value.equals("\0"))
		{
			map.put("url", value);
		}

		List<OptionLine> optLines = new ArrayList<OptionLine>();

		for (CommonsCLILauncher.Data option : availableOptions)
		{
			OptionLine oline = new OptionLine();

			oline.setShortName("-" + option.clioption.name());
			oline.setLongName("--" + option.clioption.longName());
			oline.setDataType("");

			String defaultValue = option.clioption.defaultValue();

			if (defaultValue.equals("\0"))
			{
				defaultValue = "";
			}

			String type = "";

			if (option.type != null)
			{
				switch (option.type)
				{

					case bool:
					case Bool:
						type = "boolean";
						break;
					case integer:
					case Integer:
						type = "integer";
						break;
					case string:
					case String:
					case Object:
						type = "string";
						break;
				}
			}

			oline.setDataType(type);

			oline.setDefaultValue(defaultValue);
			oline.getDescriptionLines().addAll(StringUtil.wrapTextToList(option.clioption.description(), 40));

			optLines.add(oline);
		}

		map.put("options", optLines);

		try
		{
			String template = IOUtils.toString(getClass().getResource("/usage_template.vm"));

			VelocityContext context = new VelocityContext(map);

			VelocityEngine velocityEngine = new VelocityEngine();

			velocityEngine.init();

			StringWriter w = new StringWriter();

			velocityEngine.evaluate(context, w, "log", template);

			return w.toString();
		}
		catch (IOException e)
		{
			throw new RuntimeException(e);
		}
	}
}