package org.googlecode.java_cl_parser;

import org.apache.commons.cli.Option;

@java.lang.annotation.Target({java.lang.annotation.ElementType.METHOD})
@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.RUNTIME)
public @interface CLIOption
{
	/**
	 * Literal which can be used to test the annotations for a 'null', or non-user specified value.
	 */
	public static final String NULL_STRING_VALUE = "\0";

	/**
	 * Literal which holds the default value for an array separator.
	 */
	public static final String ARRAY_SEPARATOR_DEFAULT = ",";

	enum value_type
	{
		required,
		optional,
		not_allowed
	}

	int UNLIMITED_VALUES = Option.UNLIMITED_VALUES;

	String name();

	/**
	 * Default is CLIOption.NULL_STRING_VALUE, which means no long name.
	 *
	 * @return
	 */
	String longName() default NULL_STRING_VALUE;

	String description() default "No description provided";

	/**
	 * Default is false
	 *
	 * @return
	 */
	boolean required() default false;

	/**
	 * default is value_type.optional
	 *
	 * @return
	 */
	value_type valueType() default value_type.optional;

	/**
	 * Default is 1.  0 means any, any specific number means that exact number of arguments
	 *
	 * @return
	 */
	int valueCardinality() default 1;

	/**
	 * Defines char used to separate list entries in a value list.  Default is a comma.
	 *
	 * @return
	 */
	String valueSeparator() default ARRAY_SEPARATOR_DEFAULT;

	/**
	 * Default is CLIOption.NULL_STRING_VALUE which means no default.
	 *
	 * @return
	 */
	String defaultValue() default NULL_STRING_VALUE;

	/**
	 * Defines a list of values that represent the valid argument values.
	 * CLIOption.NULL_STRING_VALUE represents no enumerated values.
	 * @return
	 */
	String [] enumeratedValues() default {};
}