/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.LogicalElement;
import java.util.Comparator;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastAggregation {
    public static <T extends LogicalElement> T and(T ... bitmaps) {
        PriorityQueue<Object> pq = new PriorityQueue<Object>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (T x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.and(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static <T extends LogicalElement> T or(T ... bitmaps) {
        PriorityQueue<Object> pq = new PriorityQueue<Object>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (T x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.or(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }

    public static <T extends LogicalElement> T xor(T ... bitmaps) {
        PriorityQueue<Object> pq = new PriorityQueue<Object>(bitmaps.length, new Comparator<T>(){

            @Override
            public int compare(T a, T b) {
                return a.sizeInBytes() - b.sizeInBytes();
            }
        });
        for (T x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            LogicalElement x1 = (LogicalElement)pq.poll();
            LogicalElement x2 = (LogicalElement)pq.poll();
            pq.add(x1.xor(x2));
        }
        return (T)((LogicalElement)pq.poll());
    }
}

