/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BitCounter;
import com.googlecode.javaewah.BitmapStorage;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.FastAggregation;
import com.googlecode.javaewah.IntIterator;
import com.googlecode.javaewah.IntIteratorImpl;
import com.googlecode.javaewah.IteratingBufferedRunningLengthWord;
import com.googlecode.javaewah.IteratingRLW;
import com.googlecode.javaewah.LogicalElement;
import com.googlecode.javaewah.NonEmptyVirtualStorage;
import com.googlecode.javaewah.RunningLengthWord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class EWAHCompressedBitmap
implements Cloneable,
Externalizable,
Iterable<Integer>,
BitmapStorage,
LogicalElement<EWAHCompressedBitmap> {
    int actualsizeinwords = 1;
    long[] buffer = null;
    RunningLengthWord rlw = null;
    int sizeinbits = 0;
    static final int defaultbuffersize = 4;
    public static final boolean usetrailingzeros = true;
    public static final boolean adjustContainerSizeWhenAggregating = true;
    public static final int wordinbits = 64;

    public EWAHCompressedBitmap() {
        this.buffer = new long[4];
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    public EWAHCompressedBitmap(int buffersize) {
        this.buffer = new long[buffersize];
        this.rlw = new RunningLengthWord(this.buffer, 0);
    }

    @Override
    public void add(long newdata) {
        this.add(newdata, 64);
    }

    public void add(long newdata, int bitsthatmatter) {
        this.sizeinbits += bitsthatmatter;
        if (newdata == 0L) {
            this.addEmptyWord(false);
        } else if (newdata == -1L) {
            this.addEmptyWord(true);
        } else {
            this.addLiteralWord(newdata);
        }
    }

    private void addEmptyWord(boolean v) {
        boolean noliteralword = this.rlw.getNumberOfLiteralWords() == 0;
        long runlen = this.rlw.getRunningLength();
        if (noliteralword && runlen == 0L) {
            this.rlw.setRunningBit(v);
        }
        if (noliteralword && this.rlw.getRunningBit() == v && runlen < 0xFFFFFFFFL) {
            this.rlw.setRunningLength(runlen + 1L);
            return;
        }
        this.push_back(0L);
        this.rlw.position = this.actualsizeinwords - 1;
        this.rlw.setRunningBit(v);
        this.rlw.setRunningLength(1L);
    }

    private void addLiteralWord(long newdata) {
        int numbersofar = this.rlw.getNumberOfLiteralWords();
        if (numbersofar >= Integer.MAX_VALUE) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            this.rlw.setNumberOfLiteralWords(1L);
            this.push_back(newdata);
        }
        this.rlw.setNumberOfLiteralWords(numbersofar + 1);
        this.push_back(newdata);
    }

    @Override
    public void addStreamOfLiteralWords(long[] data, int start, int number) {
        int leftovernumber = number;
        while (leftovernumber > 0) {
            int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatwecanadd = number < Integer.MAX_VALUE - NumberOfLiteralWords ? number : Integer.MAX_VALUE - NumberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
            this.push_back(data, start, whatwecanadd);
            this.sizeinbits += whatwecanadd * 64;
            if ((leftovernumber -= whatwecanadd) <= 0) continue;
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
        }
    }

    @Override
    public void addStreamOfEmptyWords(boolean v, long number) {
        if (number == 0L) {
            return;
        }
        this.sizeinbits = (int)((long)this.sizeinbits + number * 64L);
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        long runlen = this.rlw.getRunningLength();
        long whatwecanadd = number < 0xFFFFFFFFL - runlen ? number : 0xFFFFFFFFL - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    @Override
    public void addStreamOfNegatedLiteralWords(long[] data, int start, int number) {
        int leftovernumber = number;
        while (leftovernumber > 0) {
            int NumberOfLiteralWords = this.rlw.getNumberOfLiteralWords();
            int whatwecanadd = number < Integer.MAX_VALUE - NumberOfLiteralWords ? number : Integer.MAX_VALUE - NumberOfLiteralWords;
            this.rlw.setNumberOfLiteralWords(NumberOfLiteralWords + whatwecanadd);
            this.negative_push_back(data, start, whatwecanadd);
            this.sizeinbits += whatwecanadd * 64;
            if ((leftovernumber -= whatwecanadd) <= 0) continue;
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
        }
    }

    @Override
    public EWAHCompressedBitmap and(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andToContainer(a, container);
        return container;
    }

    public void andToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                long index = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.dischargeAsEmpty(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.andToContainer(a, counter);
        return counter.getCount();
    }

    @Override
    public EWAHCompressedBitmap andNot(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords > a.actualsizeinwords ? this.actualsizeinwords : a.actualsizeinwords);
        this.andNotToContainer(a, container);
        return container;
    }

    public void andNotToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        IteratingBufferedRunningLengthWord remaining;
        EWAHIterator i = this.getEWAHIterator();
        EWAHIterator j = a.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit() && i_is_prey || !predator.getRunningBit() && !i_is_prey) {
                    container.addStreamOfEmptyWords(false, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                if (i_is_prey) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) & (rlwj.getLiteralWordAt(k) ^ 0xFFFFFFFFFFFFFFFFL));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = remaining = i_remains ? rlwi : rlwj;
        if (i_remains) {
            remaining.discharge(container);
        } else {
            remaining.dischargeAsEmpty(container);
        }
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int andNotCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.andNotToContainer(a, counter);
        return counter.getCount();
    }

    public int cardinality() {
        int counter = 0;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                counter = (int)((long)counter + 64L * localrlw.getRunningLength());
            }
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                counter += Long.bitCount(i.buffer()[i.literalWords() + j]);
            }
        }
        return counter;
    }

    public void clear() {
        this.sizeinbits = 0;
        this.actualsizeinwords = 1;
        this.rlw.position = 0;
        this.buffer[0] = 0L;
    }

    public EWAHCompressedBitmap clone() throws CloneNotSupportedException {
        EWAHCompressedBitmap clone = (EWAHCompressedBitmap)super.clone();
        clone.buffer = (long[])this.buffer.clone();
        clone.rlw = new RunningLengthWord(clone.buffer, this.rlw.position);
        clone.actualsizeinwords = this.actualsizeinwords;
        clone.sizeinbits = this.sizeinbits;
        return clone;
    }

    public void deserialize(DataInput in) throws IOException {
        this.sizeinbits = in.readInt();
        this.actualsizeinwords = in.readInt();
        if (this.buffer.length < this.actualsizeinwords) {
            this.buffer = new long[this.actualsizeinwords];
        }
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            this.buffer[k] = in.readLong();
        }
        this.rlw = new RunningLengthWord(this.buffer, in.readInt());
    }

    public boolean equals(Object o) {
        if (o instanceof EWAHCompressedBitmap) {
            try {
                this.xorToContainer((EWAHCompressedBitmap)o, new NonEmptyVirtualStorage());
                return true;
            }
            catch (NonEmptyVirtualStorage.NonEmptyException e) {
                return false;
            }
        }
        return false;
    }

    private void fastaddStreamOfEmptyWords(boolean v, long number) {
        if (this.rlw.getRunningBit() != v && this.rlw.size() == 0L) {
            this.rlw.setRunningBit(v);
        } else if (this.rlw.getNumberOfLiteralWords() != 0 || this.rlw.getRunningBit() != v) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
        }
        long runlen = this.rlw.getRunningLength();
        long whatwecanadd = number < 0xFFFFFFFFL - runlen ? number : 0xFFFFFFFFL - runlen;
        this.rlw.setRunningLength(runlen + whatwecanadd);
        number -= whatwecanadd;
        while (number >= 0xFFFFFFFFL) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(0xFFFFFFFFL);
            number -= 0xFFFFFFFFL;
        }
        if (number > 0L) {
            this.push_back(0L);
            this.rlw.position = this.actualsizeinwords - 1;
            if (v) {
                this.rlw.setRunningBit(v);
            }
            this.rlw.setRunningLength(number);
        }
    }

    public EWAHIterator getEWAHIterator() {
        return new EWAHIterator(this.buffer, this.actualsizeinwords);
    }

    public IteratingRLW getIteratingRLW() {
        return new IteratingBufferedRunningLengthWord(this);
    }

    public List<Integer> getPositions() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        int pos = 0;
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        v.add(new Integer(pos++));
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (long data = i.buffer()[i.literalWords() + j]; data != 0L; data ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(data);
                    v.add(new Integer(ntz + pos));
                }
                pos += 64;
            }
        }
        while (v.size() > 0 && v.get(v.size() - 1) >= this.sizeinbits) {
            v.remove(v.size() - 1);
        }
        return v;
    }

    public int hashCode() {
        int karprabin = 0;
        int B = 31;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            i.next();
            if (i.rlw.getRunningBit()) {
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (i.rlw.getRunningLength() & 0xFFFFFFFFL)));
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (i.rlw.getRunningLength() >>> 32)));
            }
            for (int k = 0; k < i.rlw.getNumberOfLiteralWords(); ++k) {
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[i.literalWords() + k] & 0xFFFFFFFFL)));
                karprabin = (int)((long)karprabin + ((long)(31 * karprabin) + (this.buffer[i.literalWords() + k] >>> 32)));
            }
        }
        return karprabin;
    }

    public boolean intersects(EWAHCompressedBitmap a) {
        NonEmptyVirtualStorage nevs = new NonEmptyVirtualStorage();
        try {
            this.andToContainer(a, nevs);
        }
        catch (NonEmptyVirtualStorage.NonEmptyException nee) {
            return true;
        }
        return false;
    }

    public IntIterator intIterator() {
        return new IntIteratorImpl(new EWAHIterator(this.buffer, this.actualsizeinwords));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final IntIterator under;
            {
                this.under = EWAHCompressedBitmap.this.intIterator();
            }

            @Override
            public boolean hasNext() {
                return this.under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(this.under.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    private void negative_push_back(long[] data, int start, int number) {
        while (this.actualsizeinwords + number >= this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = this.actualsizeinwords + number < 32768 ? new long[(this.actualsizeinwords + number) * 2] : ((this.actualsizeinwords + number) * 3 / 2 < this.actualsizeinwords + number ? new long[Integer.MAX_VALUE] : new long[(this.actualsizeinwords + number) * 3 / 2]);
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        for (int k = 0; k < number; ++k) {
            this.buffer[this.actualsizeinwords + k] = data[start + k] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        this.actualsizeinwords += number;
    }

    @Override
    public void not() {
        RunningLengthWord rlw1;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        if (!i.hasNext()) {
            return;
        }
        do {
            rlw1.setRunningBit(!(rlw1 = i.next()).getRunningBit());
            for (int j = 0; j < rlw1.getNumberOfLiteralWords(); ++j) {
                i.buffer()[i.literalWords() + j] = i.buffer()[i.literalWords() + j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        } while (i.hasNext());
        int usedbitsinlast = this.sizeinbits % 64;
        if (usedbitsinlast == 0) {
            return;
        }
        if (rlw1.getNumberOfLiteralWords() == 0) {
            if (rlw1.getRunningLength() > 0L && rlw1.getRunningBit()) {
                rlw1.setRunningLength(rlw1.getRunningLength() - 1L);
                this.addLiteralWord(-1L >>> 64 - usedbitsinlast);
            }
            return;
        }
        long[] lArray = i.buffer();
        int n = i.literalWords() + rlw1.getNumberOfLiteralWords() - 1;
        lArray[n] = lArray[n] & -1L >>> 64 - usedbitsinlast;
    }

    public EWAHCompressedBitmap or(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.orToContainer(a, container);
        return container;
    }

    public void orToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (predator.getRunningBit()) {
                    container.addStreamOfEmptyWords(true, predator.getRunningLength());
                    prey.discardFirstWords(predator.getRunningLength());
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                long index = prey.discharge(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) | rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int orCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.orToContainer(a, counter);
        return counter.getCount();
    }

    private void push_back(long data) {
        if (this.actualsizeinwords == this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = oldbuffer.length < 32768 ? new long[oldbuffer.length * 2] : (oldbuffer.length * 3 / 2 < oldbuffer.length ? new long[Integer.MAX_VALUE] : new long[oldbuffer.length * 3 / 2]);
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        this.buffer[this.actualsizeinwords++] = data;
    }

    private void push_back(long[] data, int start, int number) {
        if (this.actualsizeinwords + number >= this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = this.actualsizeinwords + number < 32768 ? new long[(this.actualsizeinwords + number) * 2] : ((this.actualsizeinwords + number) * 3 / 2 < this.actualsizeinwords + number ? new long[Integer.MAX_VALUE] : new long[(this.actualsizeinwords + number) * 3 / 2]);
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
        }
        System.arraycopy(data, start, this.buffer, this.actualsizeinwords, number);
        this.actualsizeinwords += number;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.deserialize(in);
    }

    private boolean reserve(int size) {
        if (size > this.buffer.length) {
            long[] oldbuffer = this.buffer;
            this.buffer = new long[size];
            System.arraycopy(oldbuffer, 0, this.buffer, 0, oldbuffer.length);
            this.rlw.array = this.buffer;
            return true;
        }
        return false;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.sizeinbits);
        out.writeInt(this.actualsizeinwords);
        for (int k = 0; k < this.actualsizeinwords; ++k) {
            out.writeLong(this.buffer[k]);
        }
        out.writeInt(this.rlw.position);
    }

    public int serializedSizeInBytes() {
        return this.sizeInBytes() + 12;
    }

    public boolean get(int i) {
        if (i < 0 || i > this.sizeinbits) {
            return false;
        }
        IteratingRLW j = this.getIteratingRLW();
        int wordi = i / 64;
        for (int WordChecked = 0; WordChecked <= wordi; WordChecked += j.getNumberOfLiteralWords()) {
            if (wordi < (WordChecked = (int)((long)WordChecked + j.getRunningLength()))) {
                return j.getRunningBit();
            }
            if (wordi < WordChecked + j.getNumberOfLiteralWords()) {
                long w = j.getLiteralWordAt(wordi - WordChecked);
                return (w & 1L << i) != 0L;
            }
            j.next();
        }
        return false;
    }

    public boolean set(int i) {
        if (i > 0x7FFFFFBF || i < 0) {
            throw new IndexOutOfBoundsException("Set values should be between 0 and 2147483583");
        }
        if (i < this.sizeinbits) {
            return false;
        }
        int dist = (i + 64) / 64 - (this.sizeinbits + 64 - 1) / 64;
        this.sizeinbits = i + 1;
        if (dist > 0) {
            if (dist > 1) {
                this.fastaddStreamOfEmptyWords(false, dist - 1);
            }
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        if (this.rlw.getNumberOfLiteralWords() == 0) {
            this.rlw.setRunningLength(this.rlw.getRunningLength() - 1L);
            this.addLiteralWord(1L << i % 64);
            return true;
        }
        int n = this.actualsizeinwords - 1;
        this.buffer[n] = this.buffer[n] | 1L << i % 64;
        if (this.buffer[this.actualsizeinwords - 1] == -1L) {
            this.buffer[this.actualsizeinwords - 1] = 0L;
            --this.actualsizeinwords;
            this.rlw.setNumberOfLiteralWords(this.rlw.getNumberOfLiteralWords() - 1);
            this.addEmptyWord(true);
        }
        return true;
    }

    @Override
    public void setSizeInBits(int size) {
        if ((size + 64 - 1) / 64 != (this.sizeinbits + 64 - 1) / 64) {
            throw new RuntimeException("You can only reduce the size of the bitmap within the scope of the last word. To extend the bitmap, please call setSizeInbits(int,boolean).");
        }
        this.sizeinbits = size;
    }

    public boolean setSizeInBits(int size, boolean defaultvalue) {
        if (size < this.sizeinbits) {
            return false;
        }
        if (!defaultvalue) {
            EWAHCompressedBitmap.extendEmptyBits(this, this.sizeinbits, size);
        } else {
            while (this.sizeinbits % 64 != 0 && this.sizeinbits < size) {
                this.set(this.sizeinbits);
            }
            this.addStreamOfEmptyWords(defaultvalue, size / 64 - this.sizeinbits / 64);
            while (this.sizeinbits < size) {
                this.set(this.sizeinbits);
            }
        }
        this.sizeinbits = size;
        return true;
    }

    @Override
    public int sizeInBits() {
        return this.sizeinbits;
    }

    @Override
    public int sizeInBytes() {
        return this.actualsizeinwords * 8;
    }

    public int[] toArray() {
        int[] ans = new int[this.cardinality()];
        int inanspos = 0;
        int pos = 0;
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            int j;
            RunningLengthWord localrlw = i.next();
            if (localrlw.getRunningBit()) {
                j = 0;
                while ((long)j < localrlw.getRunningLength()) {
                    for (int c = 0; c < 64; ++c) {
                        ans[inanspos++] = pos++;
                    }
                    ++j;
                }
            } else {
                pos = (int)((long)pos + 64L * localrlw.getRunningLength());
            }
            for (j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                int ntz;
                for (long data = i.buffer()[i.literalWords() + j]; data != 0L; data ^= 1L << ntz) {
                    ntz = Long.numberOfTrailingZeros(data);
                    ans[inanspos++] = ntz + pos;
                }
                pos += 64;
            }
        }
        return ans;
    }

    public String toDebugString() {
        String ans = " EWAHCompressedBitmap, size in bits = " + this.sizeinbits + " size in words = " + this.actualsizeinwords + "\n";
        EWAHIterator i = new EWAHIterator(this.buffer, this.actualsizeinwords);
        while (i.hasNext()) {
            RunningLengthWord localrlw = i.next();
            ans = localrlw.getRunningBit() ? ans + localrlw.getRunningLength() + " 1x11\n" : ans + localrlw.getRunningLength() + " 0x00\n";
            ans = ans + localrlw.getNumberOfLiteralWords() + " dirties\n";
            for (int j = 0; j < localrlw.getNumberOfLiteralWords(); ++j) {
                long data = i.buffer()[i.literalWords() + j];
                ans = ans + "\t" + data + "\n";
            }
        }
        return ans;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer();
        IntIterator i = this.intIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void swap(EWAHCompressedBitmap other) {
        long[] tmp = this.buffer;
        this.buffer = other.buffer;
        other.buffer = tmp;
        RunningLengthWord tmp2 = this.rlw;
        this.rlw = other.rlw;
        other.rlw = tmp2;
        int tmp3 = this.actualsizeinwords;
        this.actualsizeinwords = other.actualsizeinwords;
        other.actualsizeinwords = tmp3;
        int tmp4 = this.sizeinbits;
        this.sizeinbits = other.sizeinbits;
        other.sizeinbits = tmp4;
    }

    public void trim() {
        this.buffer = Arrays.copyOf(this.buffer, this.actualsizeinwords);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public EWAHCompressedBitmap xor(EWAHCompressedBitmap a) {
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        container.reserve(this.actualsizeinwords + a.actualsizeinwords);
        this.xorToContainer(a, container);
        return container;
    }

    public void xorToContainer(EWAHCompressedBitmap a, BitmapStorage container) {
        EWAHIterator i = a.getEWAHIterator();
        EWAHIterator j = this.getEWAHIterator();
        IteratingBufferedRunningLengthWord rlwi = new IteratingBufferedRunningLengthWord(i);
        IteratingBufferedRunningLengthWord rlwj = new IteratingBufferedRunningLengthWord(j);
        while (rlwi.size() > 0L && rlwj.size() > 0L) {
            while (rlwi.getRunningLength() > 0L || rlwj.getRunningLength() > 0L) {
                long index;
                IteratingBufferedRunningLengthWord predator;
                boolean i_is_prey = rlwi.getRunningLength() < rlwj.getRunningLength();
                IteratingBufferedRunningLengthWord prey = i_is_prey ? rlwi : rlwj;
                IteratingBufferedRunningLengthWord iteratingBufferedRunningLengthWord = predator = i_is_prey ? rlwj : rlwi;
                if (!predator.getRunningBit()) {
                    index = prey.discharge(container, predator.getRunningLength());
                    container.addStreamOfEmptyWords(false, predator.getRunningLength() - index);
                    predator.discardFirstWords(predator.getRunningLength());
                    continue;
                }
                index = prey.dischargeNegated(container, predator.getRunningLength());
                container.addStreamOfEmptyWords(true, predator.getRunningLength() - index);
                predator.discardFirstWords(predator.getRunningLength());
            }
            int nbre_literal = Math.min(rlwi.getNumberOfLiteralWords(), rlwj.getNumberOfLiteralWords());
            if (nbre_literal <= 0) continue;
            for (int k = 0; k < nbre_literal; ++k) {
                container.add(rlwi.getLiteralWordAt(k) ^ rlwj.getLiteralWordAt(k));
            }
            rlwi.discardFirstWords(nbre_literal);
            rlwj.discardFirstWords(nbre_literal);
        }
        boolean i_remains = rlwi.size() > 0L;
        IteratingBufferedRunningLengthWord remaining = i_remains ? rlwi : rlwj;
        remaining.discharge(container);
        container.setSizeInBits(Math.max(this.sizeInBits(), a.sizeInBits()));
    }

    public int xorCardinality(EWAHCompressedBitmap a) {
        BitCounter counter = new BitCounter();
        this.xorToContainer(a, counter);
        return counter.getCount();
    }

    public static void andWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            throw new IllegalArgumentException("Need at least one bitmap");
        }
        if (bitmaps.length == 2) {
            bitmaps[0].andToContainer(bitmaps[1], container);
            return;
        }
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        EWAHCompressedBitmap tmp = new EWAHCompressedBitmap();
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length - 1; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        answer.andToContainer(bitmaps[bitmaps.length - 1], container);
    }

    public static EWAHCompressedBitmap and(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        EWAHCompressedBitmap answer = new EWAHCompressedBitmap();
        EWAHCompressedBitmap tmp = new EWAHCompressedBitmap();
        bitmaps[0].andToContainer(bitmaps[1], answer);
        for (int k = 2; k < bitmaps.length; ++k) {
            answer.andToContainer(bitmaps[k], tmp);
            tmp.swap(answer);
            tmp.clear();
        }
        return answer;
    }

    public static int andCardinality(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.andWithContainer(counter, bitmaps);
        return counter.getCount();
    }

    public static EWAHCompressedBitmap bitmapOf(int ... setbits) {
        EWAHCompressedBitmap a = new EWAHCompressedBitmap();
        for (int k : setbits) {
            a.set(k);
        }
        return a;
    }

    private static void extendEmptyBits(BitmapStorage storage, int currentSize, int newSize) {
        int currentLeftover = currentSize % 64;
        int finalLeftover = newSize % 64;
        storage.addStreamOfEmptyWords(false, newSize / 64 - currentSize / 64 + (finalLeftover != 0 ? 1 : 0) + (currentLeftover != 0 ? -1 : 0));
    }

    public static void orWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        long size = 0L;
        long sinbits = 0L;
        for (EWAHCompressedBitmap b : bitmaps) {
            size += (long)b.sizeInBytes();
            if (sinbits >= (long)b.sizeInBits()) continue;
            sinbits = b.sizeInBits();
        }
        if (size * 8L > sinbits) {
            FastAggregation.bufferedorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation.orToContainer(container, bitmaps);
        }
    }

    public static void xorWithContainer(BitmapStorage container, EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length < 2) {
            throw new IllegalArgumentException("You should provide at least two bitmaps, provided " + bitmaps.length);
        }
        long size = 0L;
        long sinbits = 0L;
        for (EWAHCompressedBitmap b : bitmaps) {
            size += (long)b.sizeInBytes();
            if (sinbits >= (long)b.sizeInBits()) continue;
            sinbits = b.sizeInBits();
        }
        if (size * 8L > sinbits) {
            FastAggregation.bufferedxorWithContainer(container, 65536, bitmaps);
        } else {
            FastAggregation.xorToContainer(container, bitmaps);
        }
    }

    public static EWAHCompressedBitmap or(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        int largestSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.orWithContainer(container, bitmaps);
        return container;
    }

    public static EWAHCompressedBitmap xor(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        EWAHCompressedBitmap container = new EWAHCompressedBitmap();
        int largestSize = 0;
        for (EWAHCompressedBitmap bitmap : bitmaps) {
            largestSize = Math.max(bitmap.actualsizeinwords, largestSize);
        }
        container.reserve((int)((double)largestSize * 1.5));
        EWAHCompressedBitmap.xorWithContainer(container, bitmaps);
        return container;
    }

    public static int orCardinality(EWAHCompressedBitmap ... bitmaps) {
        if (bitmaps.length == 1) {
            return bitmaps[0].cardinality();
        }
        BitCounter counter = new BitCounter();
        EWAHCompressedBitmap.orWithContainer(counter, bitmaps);
        return counter.getCount();
    }
}

