/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah.benchmark;

import com.googlecode.javaewah.EWAHCompressedBitmap;
import com.googlecode.javaewah.benchmark.Benchmark;
import com.googlecode.javaewah.benchmark.ClusteredDataGenerator;
import java.text.DecimalFormat;

public class BenchmarkThreshold {
    public static void main(String[] args) {
        BenchmarkThreshold.test(30, 18, 1);
    }

    public static void test(int N, int nbr, int repeat) {
        long bogus = 0L;
        DecimalFormat df = new DecimalFormat("0.###");
        ClusteredDataGenerator cdg = new ClusteredDataGenerator();
        for (int sparsity = 1; sparsity < 30 - nbr; ++sparsity) {
            for (int times = 0; times < 3; ++times) {
                String line = "";
                line = line + sparsity;
                int[][] data = new int[N][];
                int Max = 1 << nbr + sparsity;
                int[] inter = cdg.generateClustered(1 << nbr / 2, Max);
                for (int k = 0; k < N; ++k) {
                    data[k] = Benchmark.unite2by2(cdg.generateClustered(1 << nbr, Max), inter);
                }
                EWAHCompressedBitmap[] ewah = new EWAHCompressedBitmap[N];
                for (int k = 0; k < N; ++k) {
                    ewah[k] = new EWAHCompressedBitmap();
                    for (int x = 0; x < data[k].length; ++x) {
                        ewah[k].set(data[k][x]);
                    }
                    data[k] = null;
                }
                long bef = System.currentTimeMillis();
                for (int r = 0; r < repeat; ++r) {
                    for (int k = 0; k < N; ++k) {
                        EWAHCompressedBitmap[] ewahcp = new EWAHCompressedBitmap[k + 1];
                        for (int j = 0; j < k + 1; ++j) {
                            ewahcp[j] = ewah[j];
                        }
                        for (int T = 1; T < ewahcp.length + 1; ++T) {
                            EWAHCompressedBitmap ewaht = EWAHCompressedBitmap.threshold(T, ewahcp);
                            bogus += (long)ewaht.sizeInBits();
                        }
                    }
                }
                long aft = System.currentTimeMillis();
                line = line + "\t" + df.format((double)(aft - bef) / 1000.0);
                if (times <= 0) continue;
                System.out.println(line);
            }
            System.out.println("# bogus =" + bogus);
        }
    }
}

