/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.javaewah;

import com.googlecode.javaewah.BufferedRunningLengthWord;
import com.googlecode.javaewah.CloneableIterator;
import com.googlecode.javaewah.EWAHIterator;
import com.googlecode.javaewah.IteratingRLW;

public class BufferedIterator
implements IteratingRLW,
Cloneable {
    private BufferedRunningLengthWord brlw;
    private long[] buffer;
    private int literalWordStartPosition;
    private EWAHIterator iterator;
    private CloneableIterator<EWAHIterator> masterIterator;

    public BufferedIterator(CloneableIterator<EWAHIterator> iterator) {
        this.masterIterator = iterator;
        if (this.masterIterator.hasNext()) {
            this.iterator = this.masterIterator.next();
            this.brlw = new BufferedRunningLengthWord(this.iterator.next());
            this.literalWordStartPosition = this.iterator.literalWords() + this.brlw.literalWordOffset;
            this.buffer = this.iterator.buffer();
        }
    }

    @Override
    public void discardFirstWords(long x) {
        while (x > 0L) {
            if (this.brlw.runningLength > x) {
                this.brlw.runningLength -= x;
                return;
            }
            this.brlw.runningLength = 0L;
            long toDiscard = (x -= this.brlw.runningLength) > (long)this.brlw.numberOfLiteralWords ? (long)this.brlw.numberOfLiteralWords : x;
            this.literalWordStartPosition = (int)((long)this.literalWordStartPosition + toDiscard);
            this.brlw.numberOfLiteralWords = (int)((long)this.brlw.numberOfLiteralWords - toDiscard);
            if ((x -= toDiscard) <= 0L && this.brlw.size() != 0L || this.next()) continue;
            break;
        }
    }

    @Override
    public void discardRunningWords() {
        this.brlw.runningLength = 0L;
        if (this.brlw.getNumberOfLiteralWords() == 0) {
            this.next();
        }
    }

    @Override
    public boolean next() {
        if (!this.iterator.hasNext() && !this.reload()) {
            this.brlw.numberOfLiteralWords = 0;
            this.brlw.runningLength = 0L;
            return false;
        }
        this.brlw.reset(this.iterator.next());
        this.literalWordStartPosition = this.iterator.literalWords();
        return true;
    }

    private boolean reload() {
        if (!this.masterIterator.hasNext()) {
            return false;
        }
        this.iterator = this.masterIterator.next();
        this.buffer = this.iterator.buffer();
        return true;
    }

    @Override
    public long getLiteralWordAt(int index) {
        return this.buffer[this.literalWordStartPosition + index];
    }

    @Override
    public int getNumberOfLiteralWords() {
        return this.brlw.numberOfLiteralWords;
    }

    @Override
    public boolean getRunningBit() {
        return this.brlw.runningBit;
    }

    @Override
    public long getRunningLength() {
        return this.brlw.runningLength;
    }

    @Override
    public long size() {
        return this.brlw.size();
    }

    @Override
    public BufferedIterator clone() throws CloneNotSupportedException {
        BufferedIterator answer = (BufferedIterator)super.clone();
        answer.brlw = this.brlw.clone();
        answer.buffer = this.buffer;
        answer.iterator = this.iterator.clone();
        answer.literalWordStartPosition = this.literalWordStartPosition;
        answer.masterIterator = this.masterIterator.clone();
        return answer;
    }
}

