package com.googlecode.jpattern.core;

import com.googlecode.jpattern.core.command.ICommand;
import com.googlecode.jpattern.service.log.ILoggerService;
import com.googlecode.jpattern.service.log.NullLoggerService;
import com.googlecode.jpattern.service.mail.IMailService;
import com.googlecode.jpattern.service.mail.NullMailService;
import com.googlecode.jpattern.service.transaction.ITransactionService;
import com.googlecode.jpattern.service.transaction.NullTransactionService;


/**
 * 
 * @author Francesco Cina'
 *
 * 29/gen/2011
 */
public abstract class AApplicationProvider implements IProvider {

    private static final long serialVersionUID = 1L;
	private final ISystem applicationSystem;

    public AApplicationProvider(ISystem applicationSystem) {
		this.applicationSystem = applicationSystem;};

    @Override
    public boolean contains(String aServiceName) {
        return applicationSystem.getServiceMap().containsKey(aServiceName);
    }        

    @Override
    public IService getService(String aServiceName) {
        if (!contains(aServiceName)) {
            return new NullService();
        }
        return applicationSystem.getServiceMap().get(aServiceName);
    }

    @Override
	public ILoggerService getLoggerService() {
		IService service = getService(IServicesName.LOGGER_SERVICE);
		if (service instanceof ILoggerService) {
			return (ILoggerService) service;
		}
		return new NullLoggerService();
	}

	@Override
	public IMailService getMailService() {
		IService service = getService(IServicesName.MAIL_SENDER_SERVICE);
		if (service instanceof IMailService) {
			return (IMailService) service;
		}
		return new NullMailService();
	}

	@Override
	public ITransactionService getTransactionService() {
		IService service = getService(IServicesName.TRANSACTION_SERVICE);
		if (service instanceof ITransactionService) {
			return (ITransactionService) service;
		}
		return new NullTransactionService();
	}

    @Override
    public void accept(ICommand aCommand) {
        aCommand.visit( this );
    }
}
